/*
 gettimeofday micro benchmark for measurement system call performance
 
 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

int main (int argc, char *argv[])
{
	struct timeval tv, otv;
	int sec=10;
	unsigned long count;
	if(argc == 2) sec = atoi(argv[1]);
	gettimeofday(&otv,NULL);
	count = 0;
	do {
		gettimeofday(&tv,NULL);
		count ++;
	} while ( (sec - (tv.tv_sec - otv.tv_sec))*1000 >
		  (tv.tv_usec - otv.tv_usec)/1000 );
	printf("gettimeofday was called %u times per %d sec: %d nsec per call\n",
	       count, sec, sec*1000*1000/(count/1000));
	return 0;
}
