/*
 * no-op kprobe handler
 * Copyright (c) 2005 Hitachi,Ltd.,
 * Created by Masami Hiramatsu<hiramatu@sdl.hitachi.co.jp>
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/kprobes.h>

MODULE_AUTHOR("M.Hiramatsu");
MODULE_LICENSE("GPL");

static unsigned long addr = 0;
module_param(addr, ulong, 0444);

static struct kprobe kp;

static int probe_pre_handler (struct kprobe * kp,
			      struct pt_regs * regs)
{
	return 0;
}

static int install_probe(void) 
{
	int ret = -10000;
	if (addr) {
		kp.pre_handler = probe_pre_handler;
		kp.addr = (void *)addr;
		printk("probe install to %p\n", (void*)addr);
		ret = register_kprobe(&kp);
	}
	if (ret) {
		printk("probe install error: %d\n",ret);
	}
	return ret;
}

static void uninstall_probe(void)
{
	if (kp.addr) {
		printk("uninstall from %p", (void*)kp.addr);
		unregister_kprobe(&kp);
	}
}

module_init(install_probe);
module_exit(uninstall_probe);
