/*
 * no-op jprobe handler
 * Copyright (c) 2005 Hitachi,Ltd.,
 * Created by Masami Hiramatsu<hiramatu@sdl.hitachi.co.jp>
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/kprobes.h>

MODULE_AUTHOR("M.Hiramatsu");
MODULE_LICENSE("GPL");

static unsigned long addr = 0;
module_param(addr, ulong, 0444);

static struct jprobe jp;

static asmlinkage long probe_gettimeofday(struct timeval __user *tv, struct timezone __user *tz)
{
	jprobe_return();
	return -1;
}
	
static int install_probe(void) 
{
	int ret = -10000;
	if (addr) {
		jp.entry = (void*)probe_gettimeofday;
		jp.kp.addr = (void *)addr;
		printk("probe install to %p\n", (void*)addr);
		ret = register_jprobe(&jp);
	}
	if (ret != 0) {
		printk("probe install error: %d\n",ret);
	}
	return ret;
}

static void uninstall_probe(void)
{
	if (jp.kp.addr) {
		printk("uninstall from %p", (void*)jp.kp.addr);
		unregister_jprobe(&jp);
	}
}

module_init(install_probe);
module_exit(uninstall_probe);
