/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2003-2004
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 ************************************************************/

#include "ktask.h"

#define __KERNEL__
#include <linux/compiler.h>
#include <linux/sched.h>


int kt_pid(void *ktask) 
{
	return (int)((struct task_struct*)ktask)->pid;
}

int kt_cpu(void *ktask)
{
//	return (int)((struct task_struct*)ktask)->processor;
	return 0;// ktask->thread_info->cpu
}

int kt_task(void *ktask)
{
	return 0;// ktask->thread_info->task
}

char * kt_name(void *ktask)
{
	return ((struct task_struct*)ktask)->comm;
}

void * kt_next(void *ktask)
{
	return (void*)((struct task_struct*)ktask)->tasks.next;
}

void * kt_prev(void *ktask)
{
	return (void*)((struct task_struct*)ktask)->tasks.prev;
}

long kt_state(void *ktask)
{
	return (long)((struct task_struct*)ktask)->state;
}

void * kt_stack(void *ktask)
{
#ifdef CONFIG_X86
#ifdef CONFIG_64BIT
	return (void*)((struct task_struct*)ktask)->thread.rsp;
#else
	return (void*)((struct task_struct*)ktask)->thread.esp;
#endif
#else
	return NULL;
#endif
}

