/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2004,2005
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY
 *
 * Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 ************************************************************/
#include "lkst_lsm.h"

LKST_ETYPE_DEF_MODULE (0x200, INLINE, LSM_PTRACE, "LSM ptrace event",
		       "parent", "child", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x201, INLINE, LSM_CAPGET, "LSM capget event",
		       "target", "effective", "inheritable", "permitted");
LKST_ETYPE_DEF_MODULE (0x202, INLINE, LSM_CAPSET_CHECK,
		       "LSM capset_check event", "target", "effective",
		       "inheritable", "permitted");
LKST_ETYPE_DEF_MODULE (0x203, INLINE, LSM_CAPSET_SET, "LSM capset_set event",
		       "target", "effective", "inheritable", "permitted");
LKST_ETYPE_DEF_MODULE (0x204, INLINE, LSM_ACCT, "LSM acct event", "file",
		       NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x205, INLINE, LSM_SYSCTL, "LSM sysctl event", "table",
		       "op", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x206, INLINE, LSM_CAPABLE, "LSM capable event", "tsk",
		       "cap", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x207, INLINE, LSM_QUOTACTL, "LSM quotactl event",
		       "cmds", "type", "id", "sb");
LKST_ETYPE_DEF_MODULE (0x208, INLINE, LSM_QUOTA_ON, "LSM quota_on event", "f",
		       NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x209, INLINE, LSM_SYSLOG, "LSM syslog event", "type",
		       NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x20a, INLINE, LSM_VM_ENOUGH_MEMORY,
		       "LSM vm_enough_memory event", "pages", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x20b, INLINE, LSM_BPRM_ALLOC_SECURITY,
		       "LSM bprm_alloc_security event", "bprm", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x20c, INLINE, LSM_BPRM_FREE_SECURITY,
		       "LSM bprm_free_security event", "bprm", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x20d, INLINE, LSM_BPRM_APPLY_CREDS,
		       "LSM bprm_apply_creds event", "bprm", "unsafe", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x20e, INLINE, LSM_BPRM_SET_SECURITY,
		       "LSM bprm_set_security event", "bprm", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x20f, INLINE, LSM_BPRM_CHECK_SECURITY,
		       "LSM bprm_check_security event", "bprm", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x210, INLINE, LSM_BPRM_SECUREEXEC,
		       "LSM bprm_secureexec event", "bprm", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x211, INLINE, LSM_SB_ALLOC_SECURITY,
		       "LSM sb_alloc_security event", "sb", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x212, INLINE, LSM_SB_FREE_SECURITY,
		       "LSM sb_free_security event", "sb", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x213, INLINE, LSM_SB_COPY_DATA,
		       "LSM sb_copy_data event", "type", "orig", "copy",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x214, INLINE, LSM_SB_KERN_MOUNT,
		       "LSM sb_kern_mount event", "sb", "data", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x215, INLINE, LSM_SB_STATFS, "LSM sb_statfs event",
		       "sb", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x216, INLINE, LSM_SB_MOUNT, "LSM sb_mount event",
		       "dev_name", "nd", "type", "flags");
LKST_ETYPE_DEF_MODULE (0x217, INLINE, LSM_SB_CHECK_SB,
		       "LSM sb_check_sb event", "mnt", "nd", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x218, INLINE, LSM_SB_UMOUNT, "LSM sb_umount event",
		       "mnt", "flags", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x219, INLINE, LSM_SB_UMOUNT_CLOSE,
		       "LSM sb_umount_close event", "mnt", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x21a, INLINE, LSM_SB_UMOUNT_BUSY,
		       "LSM sb_umount_busy event", "mnt", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x21b, INLINE, LSM_SB_POST_REMOUNT,
		       "LSM sb_post_remount event", "mnt", "flags", "data",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x21c, INLINE, LSM_SB_POST_MOUNTROOT,
		       "LSM sb_post_mountroot event", NULL, NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x21d, INLINE, LSM_SB_POST_ADDMOUNT,
		       "LSM sb_post_addmount event", "mnt", "mountpoint_nd",
		       NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x21e, INLINE, LSM_SB_PIVOTROOT,
		       "LSM sb_pivotroot event", "old_nd", "new_nd", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x21f, INLINE, LSM_SB_POST_PIVOTROOT,
		       "LSM sb_post_pivotroot event", "old_nd", "new_nd",
		       NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x220, INLINE, LSM_INODE_ALLOC_SECURITY,
		       "LSM inode_alloc_security event", "inode", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x221, INLINE, LSM_INODE_FREE_SECURITY,
		       "LSM inode_free_security event", "inode", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x222, INLINE, LSM_INODE_CREATE,
		       "LSM inode_create event", "dir", "dentry", "mode",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x223, INLINE, LSM_INODE_POST_CREATE,
		       "LSM inode_post_create event", "dir", "dentry", "mode",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x224, INLINE, LSM_INODE_LINK, "LSM inode_link event",
		       "old_dentry", "dir", "new_dentry", NULL);
LKST_ETYPE_DEF_MODULE (0x225, INLINE, LSM_INODE_POST_LINK,
		       "LSM inode_post_link event", "old_dentry", "dir",
		       "new_dentry", NULL);
LKST_ETYPE_DEF_MODULE (0x226, INLINE, LSM_INODE_UNLINK,
		       "LSM inode_unlink event", "dir", "dentry", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x227, INLINE, LSM_INODE_SYMLINK,
		       "LSM inode_symlink event", "dir", "dentry", "old_name",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x228, INLINE, LSM_INODE_POST_SYMLINK,
		       "LSM inode_post_symlink event", "dir", "dentry",
		       "old_name", NULL);
LKST_ETYPE_DEF_MODULE (0x229, INLINE, LSM_INODE_MKDIR,
		       "LSM inode_mkdir event", "dir", "dentry", "mode",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x22a, INLINE, LSM_INODE_POST_MKDIR,
		       "LSM inode_post_mkdir event", "dir", "dentry", "mode",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x22b, INLINE, LSM_INODE_RMDIR,
		       "LSM inode_rmdir event", "dir", "dentry", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x22c, INLINE, LSM_INODE_MKNOD,
		       "LSM inode_mknod event", "dir", "dentry", "mode",
		       "dev");
LKST_ETYPE_DEF_MODULE (0x22d, INLINE, LSM_INODE_POST_MKNOD,
		       "LSM inode_post_mknod event", "dir", "dentry", "mode",
		       "dev");
LKST_ETYPE_DEF_MODULE (0x22e, INLINE, LSM_INODE_RENAME,
		       "LSM inode_rename event", "old_dir", "old_dentry",
		       "new_dir", "new_dentry");
LKST_ETYPE_DEF_MODULE (0x22f, INLINE, LSM_INODE_POST_RENAME,
		       "LSM inode_post_rename event", "old_dir", "old_dentry",
		       "new_dir", "new_dentry");
LKST_ETYPE_DEF_MODULE (0x230, INLINE, LSM_INODE_READLINK,
		       "LSM inode_readlink event", "dentry", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x231, INLINE, LSM_INODE_FOLLOW_LINK,
		       "LSM inode_follow_link event", "dentry", "nd", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x232, INLINE, LSM_INODE_PERMISSION,
		       "LSM inode_permission event", "inode", "mask", "nd",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x233, INLINE, LSM_INODE_SETATTR,
		       "LSM inode_setattr event", "dentry", "attr", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x234, INLINE, LSM_INODE_GETATTR,
		       "LSM inode_getattr event", "mnt", "dentry", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x235, INLINE, LSM_INODE_DELETE,
		       "LSM inode_delete event", "inode", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x236, INLINE, LSM_INODE_SETXATTR,
		       "LSM inode_setxattr event", "dentry", "name", "value",
		       "size");
LKST_ETYPE_DEF_MODULE (0x237, INLINE, LSM_INODE_POST_SETXATTR,
		       "LSM inode_post_setxattr event", "dentry", "name",
		       "value", "size");
LKST_ETYPE_DEF_MODULE (0x238, INLINE, LSM_INODE_GETXATTR,
		       "LSM inode_getxattr event", "dentry", "name", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x239, INLINE, LSM_INODE_LISTXATTR,
		       "LSM inode_listxattr event", "dentry", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x23a, INLINE, LSM_INODE_REMOVEXATTR,
		       "LSM inode_removexattr event", "dentry", "name", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x23b, INLINE, LSM_INODE_GETSECURITY,
		       "LSM inode_getsecurity event", "dentry", "name",
		       "buffer", "size");
LKST_ETYPE_DEF_MODULE (0x23c, INLINE, LSM_INODE_SETSECURITY,
		       "LSM inode_setsecurity event", "dentry", "name",
		       "value", "size");
LKST_ETYPE_DEF_MODULE (0x23d, INLINE, LSM_INODE_LISTSECURITY,
		       "LSM inode_listsecurity event", "dentry", "buffer",
		       NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x23e, INLINE, LSM_FILE_PERMISSION,
		       "LSM file_permission event", "file", "mask", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x23f, INLINE, LSM_FILE_ALLOC_SECURITY,
		       "LSM file_alloc_security event", "file", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x240, INLINE, LSM_FILE_FREE_SECURITY,
		       "LSM file_free_security event", "file", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x241, INLINE, LSM_FILE_IOCTL, "LSM file_ioctl event",
		       "file", "cmd", "arg", NULL);
LKST_ETYPE_DEF_MODULE (0x242, INLINE, LSM_FILE_MMAP, "LSM file_mmap event",
		       "file", "prot", "flags", NULL);
LKST_ETYPE_DEF_MODULE (0x243, INLINE, LSM_FILE_MPROTECT,
		       "LSM file_mprotect event", "vma", "prot", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x244, INLINE, LSM_FILE_LOCK, "LSM file_lock event",
		       "file", "cmd", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x245, INLINE, LSM_FILE_FCNTL, "LSM file_fcntl event",
		       "file", "cmd", "arg", NULL);
LKST_ETYPE_DEF_MODULE (0x246, INLINE, LSM_FILE_SET_FOWNER,
		       "LSM file_set_fowner event", "file", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x247, INLINE, LSM_FILE_SEND_SIGIOTASK,
		       "LSM file_send_sigiotask event", "tsk", "fown", "fd",
		       "reason");
LKST_ETYPE_DEF_MODULE (0x248, INLINE, LSM_FILE_RECEIVE,
		       "LSM file_receive event", "file", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x249, INLINE, LSM_TASK_CREATE,
		       "LSM task_create event", "clone_flags", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x24a, INLINE, LSM_TASK_ALLOC_SECURITY,
		       "LSM task_alloc_security event", "p", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x24b, INLINE, LSM_TASK_FREE_SECURITY,
		       "LSM task_free_security event", "p", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x24c, INLINE, LSM_TASK_SETUID,
		       "LSM task_setuid event", "id0", "id1", "id2", "flags");
LKST_ETYPE_DEF_MODULE (0x24d, INLINE, LSM_TASK_POST_SETUID,
		       "LSM task_post_setuid event", "old_ruid", "old_euid",
		       "old_suid", "flags");
LKST_ETYPE_DEF_MODULE (0x24e, INLINE, LSM_TASK_SETGID,
		       "LSM task_setgid event", "id0", "id1", "id2", "flags");
LKST_ETYPE_DEF_MODULE (0x24f, INLINE, LSM_TASK_SETPGID,
		       "LSM task_setpgid event", "p", "pgid", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x250, INLINE, LSM_TASK_GETPGID,
		       "LSM task_getpgid event", "p", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x251, INLINE, LSM_TASK_GETSID,
		       "LSM task_getsid event", "p", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x252, INLINE, LSM_TASK_SETGROUPS,
		       "LSM task_setgroups event", "group_info", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x253, INLINE, LSM_TASK_SETNICE,
		       "LSM task_setnice event", "p", "nice", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x254, INLINE, LSM_TASK_SETRLIMIT,
		       "LSM task_setrlimit event", "resource", "new_rlim",
		       NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x255, INLINE, LSM_TASK_SETSCHEDULER,
		       "LSM task_setscheduler event", "p", "policy", "lp",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x256, INLINE, LSM_TASK_GETSCHEDULER,
		       "LSM task_getscheduler event", "p", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x257, INLINE, LSM_TASK_KILL, "LSM task_kill event",
		       "p", "info", "sig", NULL);
LKST_ETYPE_DEF_MODULE (0x258, INLINE, LSM_TASK_WAIT, "LSM task_wait event",
		       "p", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x259, INLINE, LSM_TASK_PRCTL, "LSM task_prctl event",
		       "option", "arg2", "arg3", "arg4");
LKST_ETYPE_DEF_MODULE (0x25a, INLINE, LSM_TASK_REPARENT_TO_INIT,
		       "LSM task_reparent_to_init event", "p", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x25b, INLINE, LSM_TASK_TO_INODE,
		       "LSM task_to_inode event", "p", "inode", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x25c, INLINE, LSM_IPC_PERMISSION,
		       "LSM ipc_permission event", "ipcp", "flag", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x25d, INLINE, LSM_MSG_MSG_ALLOC_SECURITY,
		       "LSM msg_msg_alloc_security event", "msg", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x25e, INLINE, LSM_MSG_MSG_FREE_SECURITY,
		       "LSM msg_msg_free_security event", "msg", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x25f, INLINE, LSM_MSG_QUEUE_ALLOC_SECURITY,
		       "LSM msg_queue_alloc_security event", "msq", NULL,
		       NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x260, INLINE, LSM_MSG_QUEUE_FREE_SECURITY,
		       "LSM msg_queue_free_security event", "msq", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x261, INLINE, LSM_MSG_QUEUE_ASSOCIATE,
		       "LSM msg_queue_associate event", "msq", "msqflg", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x262, INLINE, LSM_MSG_QUEUE_MSGCTL,
		       "LSM msg_queue_msgctl event", "msq", "cmd", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x263, INLINE, LSM_MSG_QUEUE_MSGSND,
		       "LSM msg_queue_msgsnd event", "msq", "msg", "msqflg",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x264, INLINE, LSM_MSG_QUEUE_MSGRCV,
		       "LSM msg_queue_msgrcv event", "msq", "msg", "target",
		       "type");
LKST_ETYPE_DEF_MODULE (0x265, INLINE, LSM_SHM_ALLOC_SECURITY,
		       "LSM shm_alloc_security event", "shp", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x266, INLINE, LSM_SHM_FREE_SECURITY,
		       "LSM shm_free_security event", "shp", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x267, INLINE, LSM_SHM_ASSOCIATE,
		       "LSM shm_associate event", "shp", "shmflg", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x268, INLINE, LSM_SHM_SHMCTL, "LSM shm_shmctl event",
		       "shp", "cmd", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x269, INLINE, LSM_SHM_SHMAT, "LSM shm_shmat event",
		       "shp", "shmaddr", "shmflg", NULL);
LKST_ETYPE_DEF_MODULE (0x26a, INLINE, LSM_SEM_ALLOC_SECURITY,
		       "LSM sem_alloc_security event", "sma", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x26b, INLINE, LSM_SEM_FREE_SECURITY,
		       "LSM sem_free_security event", "sma", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x26c, INLINE, LSM_SEM_ASSOCIATE,
		       "LSM sem_associate event", "sma", "semflg", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x26d, INLINE, LSM_SEM_SEMCTL, "LSM sem_semctl event",
		       "sma", "cmd", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x26e, INLINE, LSM_SEM_SEMOP, "LSM sem_semop event",
		       "sma", "sops", "nsops", "alter");
LKST_ETYPE_DEF_MODULE (0x26f, INLINE, LSM_NETLINK_SEND,
		       "LSM netlink_send event", "sk", "skb", NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x270, INLINE, LSM_NETLINK_RECV,
		       "LSM netlink_recv event", "skb", NULL, NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x271, INLINE, LSM_REGISTER_SECURITY,
		       "LSM register_security event", "name", "ops", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x272, INLINE, LSM_UNREGISTER_SECURITY,
		       "LSM unregister_security event", "name", "ops", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x273, INLINE, LSM_D_INSTANTIATE,
		       "LSM d_instantiate event", "dentry", "inode", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x274, INLINE, LSM_GETPROCATTR,
		       "LSM getprocattr event", "p", "name", "value", "size");
LKST_ETYPE_DEF_MODULE (0x275, INLINE, LSM_SETPROCATTR,
		       "LSM setprocattr event", "p", "name", "value", "size");

#ifdef CONFIG_SECURITY_NETWORK
LKST_ETYPE_DEF_MODULE (0x276, INLINE, LSM_UNIX_STREAM_CONNECT,
		       "LSM unix_stream_connect event", "sock", "other",
		       "newsk", NULL);
LKST_ETYPE_DEF_MODULE (0x277, INLINE, LSM_UNIX_MAY_SEND,
		       "LSM unix_may_send event", "sock", "other", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x278, INLINE, LSM_SOCKET_CREATE,
		       "LSM socket_create event", "family", "type",
		       "protocol", "kern");
LKST_ETYPE_DEF_MODULE (0x279, INLINE, LSM_SOCKET_POST_CREATE,
		       "LSM socket_post_create event", "sock", "family",
		       "type", "protocol");
LKST_ETYPE_DEF_MODULE (0x27a, INLINE, LSM_SOCKET_BIND,
		       "LSM socket_bind event", "sock", "address", "addrlen",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x27b, INLINE, LSM_SOCKET_CONNECT,
		       "LSM socket_connect event", "sock", "address",
		       "addrlen", NULL);
LKST_ETYPE_DEF_MODULE (0x27c, INLINE, LSM_SOCKET_LISTEN,
		       "LSM socket_listen event", "sock", "backlog", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x27d, INLINE, LSM_SOCKET_ACCEPT,
		       "LSM socket_accept event", "sock", "newsock", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x27e, INLINE, LSM_SOCKET_POST_ACCEPT,
		       "LSM socket_post_accept event", "sock", "newsock",
		       NULL, NULL);
LKST_ETYPE_DEF_MODULE (0x27f, INLINE, LSM_SOCKET_SENDMSG,
		       "LSM socket_sendmsg event", "sock", "msg", "size",
		       NULL);
LKST_ETYPE_DEF_MODULE (0x280, INLINE, LSM_SOCKET_RECVMSG,
		       "LSM socket_recvmsg event", "sock", "msg", "size",
		       "flags");
LKST_ETYPE_DEF_MODULE (0x281, INLINE, LSM_SOCKET_GETSOCKNAME,
		       "LSM socket_getsockname event", "sock", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x282, INLINE, LSM_SOCKET_GETPEERNAME,
		       "LSM socket_getpeername event", "sock", NULL, NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x283, INLINE, LSM_SOCKET_GETSOCKOPT,
		       "LSM socket_getsockopt event", "sock", "level",
		       "optname", NULL);
LKST_ETYPE_DEF_MODULE (0x284, INLINE, LSM_SOCKET_SETSOCKOPT,
		       "LSM socket_setsockopt event", "sock", "level",
		       "optname", NULL);
LKST_ETYPE_DEF_MODULE (0x285, INLINE, LSM_SOCKET_SHUTDOWN,
		       "LSM socket_shutdown event", "sock", "how", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x286, INLINE, LSM_SOCKET_SOCK_RCV_SKB,
		       "LSM socket_sock_rcv_skb event", "sk", "skb", NULL,
		       NULL);
LKST_ETYPE_DEF_MODULE (0x287, INLINE, LSM_SOCKET_GETPEERSEC,
		       "LSM socket_getpeersec event", "sock", "optval",
		       "optlen", "len");
LKST_ETYPE_DEF_MODULE (0x288, INLINE, LSM_SK_ALLOC_SECURITY,
		       "LSM sk_alloc_security event", "sk", "family",
		       "priority", NULL);
LKST_ETYPE_DEF_MODULE (0x289, INLINE, LSM_SK_FREE_SECURITY,
		       "LSM sk_free_security event", "sk", NULL, NULL, NULL);
#endif

static int
lkst_lsm_ptrace (struct task_struct *parent, struct task_struct *child)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_PTRACE, LKST_ARGP (parent),
		   LKST_ARGP (child), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->ptrace (parent, child);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_PTRACE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_capget (struct task_struct *target, kernel_cap_t * effective,
		 kernel_cap_t * inheritable, kernel_cap_t * permitted)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_CAPGET, LKST_ARGP (target),
		   LKST_ARGP (effective), LKST_ARGP (inheritable),
		   LKST_ARGP (permitted));
	retv = real_ops->capget (target, effective, inheritable, permitted);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_CAPGET, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_capset_check (struct task_struct *target, kernel_cap_t * effective,
		       kernel_cap_t * inheritable, kernel_cap_t * permitted)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_CAPSET_CHECK, LKST_ARGP (target),
		   LKST_ARGP (effective), LKST_ARGP (inheritable),
		   LKST_ARGP (permitted));
	retv = real_ops->capset_check (target, effective, inheritable,
				       permitted);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_CAPSET_CHECK, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_capset_set (struct task_struct *target, kernel_cap_t * effective,
		     kernel_cap_t * inheritable, kernel_cap_t * permitted)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_CAPSET_SET, LKST_ARGP (target),
		   LKST_ARGP (effective), LKST_ARGP (inheritable),
		   LKST_ARGP (permitted));
	real_ops->capset_set (target, effective, inheritable, permitted);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_CAPSET_SET, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_acct (struct file *file)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_ACCT, LKST_ARGP (file), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->acct (file);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_ACCT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sysctl (ctl_table * table, int op)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SYSCTL, LKST_ARGP (table), LKST_ARG (op),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sysctl (table, op);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SYSCTL, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_capable (struct task_struct *tsk, int cap)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_CAPABLE, LKST_ARGP (tsk), LKST_ARG (cap),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->capable (tsk, cap);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_CAPABLE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_quotactl (int cmds, int type, int id, struct super_block *sb)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_QUOTACTL, LKST_ARG (cmds), LKST_ARG (type),
		   LKST_ARG (id), LKST_ARGP (sb));
	retv = real_ops->quotactl (cmds, type, id, sb);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_QUOTACTL, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_quota_on (struct file *f)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_QUOTA_ON, LKST_ARGP (f), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->quota_on (f);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_QUOTA_ON, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_syslog (int type)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SYSLOG, LKST_ARG (type), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->syslog (type);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SYSLOG, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_vm_enough_memory (long pages)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_VM_ENOUGH_MEMORY, LKST_ARG (pages),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->vm_enough_memory (pages);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_VM_ENOUGH_MEMORY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_bprm_alloc_security (struct linux_binprm *bprm)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_ALLOC_SECURITY, LKST_ARGP (bprm),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->bprm_alloc_security (bprm);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_bprm_free_security (struct linux_binprm *bprm)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_FREE_SECURITY, LKST_ARGP (bprm),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->bprm_free_security (bprm);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static void
lkst_lsm_bprm_apply_creds (struct linux_binprm *bprm, int unsafe)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_APPLY_CREDS, LKST_ARGP (bprm),
		   LKST_ARG (unsafe), LKST_ARG (0), LKST_ARG (0));
	real_ops->bprm_apply_creds (bprm, unsafe);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_APPLY_CREDS, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_bprm_set_security (struct linux_binprm *bprm)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_SET_SECURITY, LKST_ARGP (bprm),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->bprm_set_security (bprm);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_SET_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_bprm_check_security (struct linux_binprm *bprm)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_CHECK_SECURITY, LKST_ARGP (bprm),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->bprm_check_security (bprm);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_CHECK_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_bprm_secureexec (struct linux_binprm *bprm)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_SECUREEXEC, LKST_ARGP (bprm),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->bprm_secureexec (bprm);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_BPRM_SECUREEXEC, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sb_alloc_security (struct super_block *sb)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_ALLOC_SECURITY, LKST_ARGP (sb),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sb_alloc_security (sb);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_sb_free_security (struct super_block *sb)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_FREE_SECURITY, LKST_ARGP (sb),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->sb_free_security (sb);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_sb_copy_data (struct file_system_type *type, void *orig, void *copy)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_COPY_DATA, LKST_ARGP (type),
		   LKST_ARGP (orig), LKST_ARGP (copy), LKST_ARG (0));
	retv = real_ops->sb_copy_data (type, orig, copy);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_COPY_DATA, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sb_kern_mount (struct super_block *sb, void *data)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_KERN_MOUNT, LKST_ARGP (sb),
		   LKST_ARGP (data), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sb_kern_mount (sb, data);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_KERN_MOUNT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sb_statfs (struct super_block *sb)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_STATFS, LKST_ARGP (sb), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sb_statfs (sb);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_STATFS, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sb_mount (char *dev_name, struct nameidata *nd, char *type,
		   unsigned long flags, void *data)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_MOUNT, LKST_ARGP (dev_name),
		   LKST_ARGP (nd), LKST_ARGP (type), LKST_ARG (flags));
	retv = real_ops->sb_mount (dev_name, nd, type, flags, data);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_MOUNT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sb_check_sb (struct vfsmount *mnt, struct nameidata *nd)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_CHECK_SB, LKST_ARGP (mnt),
		   LKST_ARGP (nd), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sb_check_sb (mnt, nd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_CHECK_SB, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sb_umount (struct vfsmount *mnt, int flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_UMOUNT, LKST_ARGP (mnt),
		   LKST_ARG (flags), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sb_umount (mnt, flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_UMOUNT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_sb_umount_close (struct vfsmount *mnt)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_UMOUNT_CLOSE, LKST_ARGP (mnt),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->sb_umount_close (mnt);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_UMOUNT_CLOSE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	return;
}

static void
lkst_lsm_sb_umount_busy (struct vfsmount *mnt)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_UMOUNT_BUSY, LKST_ARGP (mnt),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->sb_umount_busy (mnt);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_UMOUNT_BUSY, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	return;
}

static void
lkst_lsm_sb_post_remount (struct vfsmount *mnt, unsigned long flags,
			  void *data)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_POST_REMOUNT, LKST_ARGP (mnt),
		   LKST_ARG (flags), LKST_ARGP (data), LKST_ARG (0));
	real_ops->sb_post_remount (mnt, flags, data);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_POST_REMOUNT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	return;
}

static void
lkst_lsm_sb_post_mountroot (void)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_POST_MOUNTROOT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->sb_post_mountroot ();
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_POST_MOUNTROOT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static void
lkst_lsm_sb_post_addmount (struct vfsmount *mnt,
			   struct nameidata *mountpoint_nd)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_POST_ADDMOUNT, LKST_ARGP (mnt),
		   LKST_ARGP (mountpoint_nd), LKST_ARG (0), LKST_ARG (0));
	real_ops->sb_post_addmount (mnt, mountpoint_nd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_POST_ADDMOUNT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_sb_pivotroot (struct nameidata *old_nd, struct nameidata *new_nd)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_PIVOTROOT, LKST_ARGP (old_nd),
		   LKST_ARGP (new_nd), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sb_pivotroot (old_nd, new_nd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_PIVOTROOT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_sb_post_pivotroot (struct nameidata *old_nd,
			    struct nameidata *new_nd)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_POST_PIVOTROOT, LKST_ARGP (old_nd),
		   LKST_ARGP (new_nd), LKST_ARG (0), LKST_ARG (0));
	real_ops->sb_post_pivotroot (old_nd, new_nd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SB_POST_PIVOTROOT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_alloc_security (struct inode *inode)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_ALLOC_SECURITY, LKST_ARGP (inode),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_alloc_security (inode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_free_security (struct inode *inode)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_FREE_SECURITY, LKST_ARGP (inode),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->inode_free_security (inode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_create (struct inode *dir, struct dentry *dentry, int mode)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_CREATE, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARG (mode), LKST_ARG (0));
	retv = real_ops->inode_create (dir, dentry, mode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_CREATE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_post_create (struct inode *dir, struct dentry *dentry,
			    int mode)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_CREATE, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARG (mode), LKST_ARG (0));
	real_ops->inode_post_create (dir, dentry, mode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_CREATE, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_link (struct dentry *old_dentry, struct inode *dir,
		     struct dentry *new_dentry)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_LINK, LKST_ARGP (old_dentry),
		   LKST_ARGP (dir), LKST_ARGP (new_dentry), LKST_ARG (0));
	retv = real_ops->inode_link (old_dentry, dir, new_dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_LINK, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_post_link (struct dentry *old_dentry, struct inode *dir,
			  struct dentry *new_dentry)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_LINK, LKST_ARGP (old_dentry),
		   LKST_ARGP (dir), LKST_ARGP (new_dentry), LKST_ARG (0));
	real_ops->inode_post_link (old_dentry, dir, new_dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_LINK, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_unlink (struct inode *dir, struct dentry *dentry)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_UNLINK, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_unlink (dir, dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_UNLINK, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_symlink (struct inode *dir, struct dentry *dentry,
			const char *old_name)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_SYMLINK, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARGP (old_name), LKST_ARG (0));
	retv = real_ops->inode_symlink (dir, dentry, old_name);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_SYMLINK, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_post_symlink (struct inode *dir, struct dentry *dentry,
			     const char *old_name)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_SYMLINK, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARGP (old_name), LKST_ARG (0));
	real_ops->inode_post_symlink (dir, dentry, old_name);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_SYMLINK, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_mkdir (struct inode *dir, struct dentry *dentry, int mode)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_MKDIR, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARG (mode), LKST_ARG (0));
	retv = real_ops->inode_mkdir (dir, dentry, mode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_MKDIR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_post_mkdir (struct inode *dir, struct dentry *dentry, int mode)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_MKDIR, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARG (mode), LKST_ARG (0));
	real_ops->inode_post_mkdir (dir, dentry, mode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_MKDIR, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_rmdir (struct inode *dir, struct dentry *dentry)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_RMDIR, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_rmdir (dir, dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_RMDIR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_mknod (struct inode *dir, struct dentry *dentry, int mode,
		      dev_t dev)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_MKNOD, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARG (mode), LKST_ARG (dev));
	retv = real_ops->inode_mknod (dir, dentry, mode, dev);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_MKNOD, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_post_mknod (struct inode *dir, struct dentry *dentry, int mode,
			   dev_t dev)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_MKNOD, LKST_ARGP (dir),
		   LKST_ARGP (dentry), LKST_ARG (mode), LKST_ARG (dev));
	real_ops->inode_post_mknod (dir, dentry, mode, dev);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_MKNOD, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_rename (struct inode *old_dir, struct dentry *old_dentry,
		       struct inode *new_dir, struct dentry *new_dentry)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_RENAME, LKST_ARGP (old_dir),
		   LKST_ARGP (old_dentry), LKST_ARGP (new_dir),
		   LKST_ARGP (new_dentry));
	retv = real_ops->inode_rename (old_dir, old_dentry, new_dir,
				       new_dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_RENAME, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_post_rename (struct inode *old_dir, struct dentry *old_dentry,
			    struct inode *new_dir, struct dentry *new_dentry)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_RENAME, LKST_ARGP (old_dir),
		   LKST_ARGP (old_dentry), LKST_ARGP (new_dir),
		   LKST_ARGP (new_dentry));
	real_ops->inode_post_rename (old_dir, old_dentry, new_dir,
				     new_dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_RENAME, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_readlink (struct dentry *dentry)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_READLINK, LKST_ARGP (dentry),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_readlink (dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_READLINK, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_follow_link (struct dentry *dentry, struct nameidata *nd)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_FOLLOW_LINK, LKST_ARGP (dentry),
		   LKST_ARGP (nd), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_follow_link (dentry, nd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_FOLLOW_LINK, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_permission (struct inode *inode, int mask,
			   struct nameidata *nd)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_PERMISSION, LKST_ARGP (inode),
		   LKST_ARG (mask), LKST_ARGP (nd), LKST_ARG (0));
	retv = real_ops->inode_permission (inode, mask, nd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_PERMISSION, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_setattr (struct dentry *dentry, struct iattr *attr)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_SETATTR, LKST_ARGP (dentry),
		   LKST_ARGP (attr), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_setattr (dentry, attr);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_SETATTR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_getattr (struct vfsmount *mnt, struct dentry *dentry)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_GETATTR, LKST_ARGP (mnt),
		   LKST_ARGP (dentry), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_getattr (mnt, dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_GETATTR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_delete (struct inode *inode)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_DELETE, LKST_ARGP (inode),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->inode_delete (inode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_DELETE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_setxattr (struct dentry *dentry, char *name, void *value,
			 size_t size, int flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_SETXATTR, LKST_ARGP (dentry),
		   LKST_ARGP (name), LKST_ARGP (value), LKST_ARG (size));
	retv = real_ops->inode_setxattr (dentry, name, value, size, flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_SETXATTR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_inode_post_setxattr (struct dentry *dentry, char *name, void *value,
			      size_t size, int flags)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_SETXATTR, LKST_ARGP (dentry),
		   LKST_ARGP (name), LKST_ARGP (value), LKST_ARG (size));
	real_ops->inode_post_setxattr (dentry, name, value, size, flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_POST_SETXATTR, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_inode_getxattr (struct dentry *dentry, char *name)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_GETXATTR, LKST_ARGP (dentry),
		   LKST_ARGP (name), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_getxattr (dentry, name);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_GETXATTR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_listxattr (struct dentry *dentry)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_LISTXATTR, LKST_ARGP (dentry),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_listxattr (dentry);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_LISTXATTR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_removexattr (struct dentry *dentry, char *name)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_REMOVEXATTR, LKST_ARGP (dentry),
		   LKST_ARGP (name), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_removexattr (dentry, name);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_REMOVEXATTR, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_getsecurity (struct dentry *dentry, const char *name,
			    void *buffer, size_t size)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_GETSECURITY, LKST_ARGP (dentry),
		   LKST_ARGP (name), LKST_ARGP (buffer), LKST_ARG (size));
	retv = real_ops->inode_getsecurity (dentry, name, buffer, size);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_GETSECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_setsecurity (struct dentry *dentry, const char *name,
			    const void *value, size_t size, int flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_SETSECURITY, LKST_ARGP (dentry),
		   LKST_ARGP (name), LKST_ARGP (value), LKST_ARG (size));
	retv = real_ops->inode_setsecurity (dentry, name, value, size, flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_SETSECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_inode_listsecurity (struct dentry *dentry, char *buffer)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_LISTSECURITY, LKST_ARGP (dentry),
		   LKST_ARGP (buffer), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->inode_listsecurity (dentry, buffer);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_INODE_LISTSECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_permission (struct file *file, int mask)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_PERMISSION, LKST_ARGP (file),
		   LKST_ARG (mask), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->file_permission (file, mask);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_PERMISSION, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_alloc_security (struct file *file)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_ALLOC_SECURITY, LKST_ARGP (file),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->file_alloc_security (file);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_file_free_security (struct file *file)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_FREE_SECURITY, LKST_ARGP (file),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->file_free_security (file);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_file_ioctl (struct file *file, unsigned int cmd, unsigned long arg)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_IOCTL, LKST_ARGP (file),
		   LKST_ARG (cmd), LKST_ARG (arg), LKST_ARG (0));
	retv = real_ops->file_ioctl (file, cmd, arg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_IOCTL, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_mmap (struct file *file, unsigned long prot,
		    unsigned long flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_MMAP, LKST_ARGP (file),
		   LKST_ARG (prot), LKST_ARG (flags), LKST_ARG (0));
	retv = real_ops->file_mmap (file, prot, flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_MMAP, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_mprotect (struct vm_area_struct *vma, unsigned long prot)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_MPROTECT, LKST_ARGP (vma),
		   LKST_ARG (prot), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->file_mprotect (vma, prot);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_MPROTECT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_lock (struct file *file, unsigned int cmd)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_LOCK, LKST_ARGP (file), LKST_ARG (cmd),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->file_lock (file, cmd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_LOCK, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_fcntl (struct file *file, unsigned int cmd, unsigned long arg)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_FCNTL, LKST_ARGP (file),
		   LKST_ARG (cmd), LKST_ARG (arg), LKST_ARG (0));
	retv = real_ops->file_fcntl (file, cmd, arg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_FCNTL, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_set_fowner (struct file *file)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_SET_FOWNER, LKST_ARGP (file),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->file_set_fowner (file);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_SET_FOWNER, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_send_sigiotask (struct task_struct *tsk,
			      struct fown_struct *fown, int fd, int reason)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_SEND_SIGIOTASK, LKST_ARGP (tsk),
		   LKST_ARGP (fown), LKST_ARG (fd), LKST_ARG (reason));
	retv = real_ops->file_send_sigiotask (tsk, fown, fd, reason);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_SEND_SIGIOTASK, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_file_receive (struct file *file)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_RECEIVE, LKST_ARGP (file),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->file_receive (file);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_FILE_RECEIVE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_create (unsigned long clone_flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_CREATE, LKST_ARG (clone_flags),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_create (clone_flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_CREATE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_alloc_security (struct task_struct *p)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_ALLOC_SECURITY, LKST_ARGP (p),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_alloc_security (p);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_task_free_security (struct task_struct *p)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_FREE_SECURITY, LKST_ARGP (p),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->task_free_security (p);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_task_setuid (uid_t id0, uid_t id1, uid_t id2, int flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETUID, LKST_ARG (id0), LKST_ARG (id1),
		   LKST_ARG (id2), LKST_ARG (flags));
	retv = real_ops->task_setuid (id0, id1, id2, flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETUID, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_post_setuid (uid_t old_ruid, uid_t old_euid, uid_t old_suid,
			   int flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_POST_SETUID, LKST_ARG (old_ruid),
		   LKST_ARG (old_euid), LKST_ARG (old_suid),
		   LKST_ARG (flags));
	retv = real_ops->task_post_setuid (old_ruid, old_euid, old_suid,
					   flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_POST_SETUID, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_setgid (gid_t id0, gid_t id1, gid_t id2, int flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETGID, LKST_ARG (id0), LKST_ARG (id1),
		   LKST_ARG (id2), LKST_ARG (flags));
	retv = real_ops->task_setgid (id0, id1, id2, flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETGID, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_setpgid (struct task_struct *p, pid_t pgid)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETPGID, LKST_ARGP (p),
		   LKST_ARG (pgid), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_setpgid (p, pgid);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETPGID, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_getpgid (struct task_struct *p)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_GETPGID, LKST_ARGP (p), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_getpgid (p);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_GETPGID, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_getsid (struct task_struct *p)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_GETSID, LKST_ARGP (p), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_getsid (p);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_GETSID, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_setgroups (struct group_info *group_info)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETGROUPS, LKST_ARGP (group_info),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_setgroups (group_info);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETGROUPS, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_setnice (struct task_struct *p, int nice)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETNICE, LKST_ARGP (p),
		   LKST_ARG (nice), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_setnice (p, nice);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETNICE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_setrlimit (unsigned int resource, struct rlimit *new_rlim)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETRLIMIT, LKST_ARG (resource),
		   LKST_ARGP (new_rlim), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_setrlimit (resource, new_rlim);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETRLIMIT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_setscheduler (struct task_struct *p, int policy,
			    struct sched_param *lp)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETSCHEDULER, LKST_ARGP (p),
		   LKST_ARG (policy), LKST_ARGP (lp), LKST_ARG (0));
	retv = real_ops->task_setscheduler (p, policy, lp);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_SETSCHEDULER, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_getscheduler (struct task_struct *p)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_GETSCHEDULER, LKST_ARGP (p),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_getscheduler (p);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_GETSCHEDULER, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_kill (struct task_struct *p, struct siginfo *info, int sig)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_KILL, LKST_ARGP (p), LKST_ARGP (info),
		   LKST_ARG (sig), LKST_ARG (0));
	retv = real_ops->task_kill (p, info, sig);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_KILL, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_wait (struct task_struct *p)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_WAIT, LKST_ARGP (p), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->task_wait (p);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_WAIT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_task_prctl (int option, unsigned long arg2, unsigned long arg3,
		     unsigned long arg4, unsigned long arg5)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_PRCTL, LKST_ARG (option),
		   LKST_ARG (arg2), LKST_ARG (arg3), LKST_ARG (arg4));
	retv = real_ops->task_prctl (option, arg2, arg3, arg4, arg5);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_PRCTL, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_task_reparent_to_init (struct task_struct *p)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_REPARENT_TO_INIT, LKST_ARGP (p),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->task_reparent_to_init (p);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_REPARENT_TO_INIT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static void
lkst_lsm_task_to_inode (struct task_struct *p, struct inode *inode)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_TO_INODE, LKST_ARGP (p),
		   LKST_ARGP (inode), LKST_ARG (0), LKST_ARG (0));
	real_ops->task_to_inode (p, inode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_TASK_TO_INODE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_ipc_permission (struct kern_ipc_perm *ipcp, short flag)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_IPC_PERMISSION, LKST_ARGP (ipcp),
		   LKST_ARG (flag), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->ipc_permission (ipcp, flag);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_IPC_PERMISSION, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_msg_msg_alloc_security (struct msg_msg *msg)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_MSG_ALLOC_SECURITY, LKST_ARGP (msg),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->msg_msg_alloc_security (msg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_MSG_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_msg_msg_free_security (struct msg_msg *msg)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_MSG_FREE_SECURITY, LKST_ARGP (msg),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->msg_msg_free_security (msg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_MSG_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_msg_queue_alloc_security (struct msg_queue *msq)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_ALLOC_SECURITY, LKST_ARGP (msq),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->msg_queue_alloc_security (msq);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_msg_queue_free_security (struct msg_queue *msq)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_FREE_SECURITY, LKST_ARGP (msq),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->msg_queue_free_security (msq);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_msg_queue_associate (struct msg_queue *msq, int msqflg)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_ASSOCIATE, LKST_ARGP (msq),
		   LKST_ARG (msqflg), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->msg_queue_associate (msq, msqflg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_ASSOCIATE, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_msg_queue_msgctl (struct msg_queue *msq, int cmd)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_MSGCTL, LKST_ARGP (msq),
		   LKST_ARG (cmd), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->msg_queue_msgctl (msq, cmd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_MSGCTL, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_msg_queue_msgsnd (struct msg_queue *msq, struct msg_msg *msg,
			   int msqflg)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_MSGSND, LKST_ARGP (msq),
		   LKST_ARGP (msg), LKST_ARG (msqflg), LKST_ARG (0));
	retv = real_ops->msg_queue_msgsnd (msq, msg, msqflg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_MSGSND, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_msg_queue_msgrcv (struct msg_queue *msq, struct msg_msg *msg,
			   struct task_struct *target, long type, int mode)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_MSGRCV, LKST_ARGP (msq),
		   LKST_ARGP (msg), LKST_ARGP (target), LKST_ARG (type));
	retv = real_ops->msg_queue_msgrcv (msq, msg, target, type, mode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_MSG_QUEUE_MSGRCV, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_shm_alloc_security (struct shmid_kernel *shp)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_ALLOC_SECURITY, LKST_ARGP (shp),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->shm_alloc_security (shp);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_shm_free_security (struct shmid_kernel *shp)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_FREE_SECURITY, LKST_ARGP (shp),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->shm_free_security (shp);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_shm_associate (struct shmid_kernel *shp, int shmflg)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_ASSOCIATE, LKST_ARGP (shp),
		   LKST_ARG (shmflg), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->shm_associate (shp, shmflg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_ASSOCIATE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_shm_shmctl (struct shmid_kernel *shp, int cmd)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_SHMCTL, LKST_ARGP (shp), LKST_ARG (cmd),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->shm_shmctl (shp, cmd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_SHMCTL, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_shm_shmat (struct shmid_kernel *shp, char __user * shmaddr,
		    int shmflg)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_SHMAT, LKST_ARGP (shp),
		   LKST_ARGP (shmaddr), LKST_ARG (shmflg), LKST_ARG (0));
	retv = real_ops->shm_shmat (shp, shmaddr, shmflg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SHM_SHMAT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sem_alloc_security (struct sem_array *sma)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_ALLOC_SECURITY, LKST_ARGP (sma),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sem_alloc_security (sma);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_sem_free_security (struct sem_array *sma)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_FREE_SECURITY, LKST_ARGP (sma),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->sem_free_security (sma);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_sem_associate (struct sem_array *sma, int semflg)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_ASSOCIATE, LKST_ARGP (sma),
		   LKST_ARG (semflg), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sem_associate (sma, semflg);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_ASSOCIATE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sem_semctl (struct sem_array *sma, int cmd)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_SEMCTL, LKST_ARGP (sma), LKST_ARG (cmd),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->sem_semctl (sma, cmd);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_SEMCTL, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sem_semop (struct sem_array *sma, struct sembuf *sops,
		    unsigned nsops, int alter)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_SEMOP, LKST_ARGP (sma),
		   LKST_ARGP (sops), LKST_ARG (nsops), LKST_ARG (alter));
	retv = real_ops->sem_semop (sma, sops, nsops, alter);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SEM_SEMOP, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_netlink_send (struct sock *sk, struct sk_buff *skb)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_NETLINK_SEND, LKST_ARGP (sk),
		   LKST_ARGP (skb), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->netlink_send (sk, skb);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_NETLINK_SEND, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_netlink_recv (struct sk_buff *skb)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_NETLINK_RECV, LKST_ARGP (skb), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->netlink_recv (skb);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_NETLINK_RECV, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_register_security (const char *name, struct security_operations *ops)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_REGISTER_SECURITY, LKST_ARGP (name),
		   LKST_ARGP (ops), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->register_security (name, ops);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_REGISTER_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_unregister_security (const char *name,
			      struct security_operations *ops)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_UNREGISTER_SECURITY, LKST_ARGP (name),
		   LKST_ARGP (ops), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->unregister_security (name, ops);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_UNREGISTER_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_d_instantiate (struct dentry *dentry, struct inode *inode)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_D_INSTANTIATE, LKST_ARGP (dentry),
		   LKST_ARGP (inode), LKST_ARG (0), LKST_ARG (0));
	real_ops->d_instantiate (dentry, inode);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_D_INSTANTIATE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_getprocattr (struct task_struct *p, char *name, void *value,
		      size_t size)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_GETPROCATTR, LKST_ARGP (p),
		   LKST_ARGP (name), LKST_ARGP (value), LKST_ARG (size));
	retv = real_ops->getprocattr (p, name, value, size);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_GETPROCATTR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_setprocattr (struct task_struct *p, char *name, void *value,
		      size_t size)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SETPROCATTR, LKST_ARGP (p),
		   LKST_ARGP (name), LKST_ARGP (value), LKST_ARG (size));
	retv = real_ops->setprocattr (p, name, value, size);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SETPROCATTR, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

#ifdef CONFIG_SECURITY_NETWORK
static int
lkst_lsm_unix_stream_connect (struct socket *sock, struct socket *other,
			      struct sock *newsk)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_UNIX_STREAM_CONNECT, LKST_ARGP (sock),
		   LKST_ARGP (other), LKST_ARGP (newsk), LKST_ARG (0));
	retv = real_ops->unix_stream_connect (sock, other, newsk);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_UNIX_STREAM_CONNECT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_unix_may_send (struct socket *sock, struct socket *other)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_UNIX_MAY_SEND, LKST_ARGP (sock),
		   LKST_ARGP (other), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->unix_may_send (sock, other);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_UNIX_MAY_SEND, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_create (int family, int type, int protocol, int kern)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_CREATE, LKST_ARG (family),
		   LKST_ARG (type), LKST_ARG (protocol), LKST_ARG (kern));
	retv = real_ops->socket_create (family, type, protocol, kern);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_CREATE, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_socket_post_create (struct socket *sock, int family, int type,
			     int protocol, int kern)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_POST_CREATE, LKST_ARGP (sock),
		   LKST_ARG (family), LKST_ARG (type), LKST_ARG (protocol));
	real_ops->socket_post_create (sock, family, type, protocol, kern);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_POST_CREATE, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_socket_bind (struct socket *sock, struct sockaddr *address,
		      int addrlen)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_BIND, LKST_ARGP (sock),
		   LKST_ARGP (address), LKST_ARG (addrlen), LKST_ARG (0));
	retv = real_ops->socket_bind (sock, address, addrlen);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_BIND, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_connect (struct socket *sock, struct sockaddr *address,
			 int addrlen)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_CONNECT, LKST_ARGP (sock),
		   LKST_ARGP (address), LKST_ARG (addrlen), LKST_ARG (0));
	retv = real_ops->socket_connect (sock, address, addrlen);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_CONNECT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_listen (struct socket *sock, int backlog)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_LISTEN, LKST_ARGP (sock),
		   LKST_ARG (backlog), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->socket_listen (sock, backlog);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_LISTEN, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_accept (struct socket *sock, struct socket *newsock)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_ACCEPT, LKST_ARGP (sock),
		   LKST_ARGP (newsock), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->socket_accept (sock, newsock);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_ACCEPT, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_socket_post_accept (struct socket *sock, struct socket *newsock)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_POST_ACCEPT, LKST_ARGP (sock),
		   LKST_ARGP (newsock), LKST_ARG (0), LKST_ARG (0));
	real_ops->socket_post_accept (sock, newsock);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_POST_ACCEPT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}

static int
lkst_lsm_socket_sendmsg (struct socket *sock, struct msghdr *msg, int size)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_SENDMSG, LKST_ARGP (sock),
		   LKST_ARGP (msg), LKST_ARG (size), LKST_ARG (0));
	retv = real_ops->socket_sendmsg (sock, msg, size);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_SENDMSG, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_recvmsg (struct socket *sock, struct msghdr *msg, int size,
			 int flags)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_RECVMSG, LKST_ARGP (sock),
		   LKST_ARGP (msg), LKST_ARG (size), LKST_ARG (flags));
	retv = real_ops->socket_recvmsg (sock, msg, size, flags);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_RECVMSG, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_getsockname (struct socket *sock)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_GETSOCKNAME, LKST_ARGP (sock),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->socket_getsockname (sock);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_GETSOCKNAME, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_getpeername (struct socket *sock)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_GETPEERNAME, LKST_ARGP (sock),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->socket_getpeername (sock);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_GETPEERNAME, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_getsockopt (struct socket *sock, int level, int optname)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_GETSOCKOPT, LKST_ARGP (sock),
		   LKST_ARG (level), LKST_ARG (optname), LKST_ARG (0));
	retv = real_ops->socket_getsockopt (sock, level, optname);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_GETSOCKOPT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_setsockopt (struct socket *sock, int level, int optname)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_SETSOCKOPT, LKST_ARGP (sock),
		   LKST_ARG (level), LKST_ARG (optname), LKST_ARG (0));
	retv = real_ops->socket_setsockopt (sock, level, optname);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_SETSOCKOPT, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_shutdown (struct socket *sock, int how)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_SHUTDOWN, LKST_ARGP (sock),
		   LKST_ARG (how), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->socket_shutdown (sock, how);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_SHUTDOWN, LKST_ARG (0), LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_sock_rcv_skb (struct sock *sk, struct sk_buff *skb)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_SOCK_RCV_SKB, LKST_ARGP (sk),
		   LKST_ARGP (skb), LKST_ARG (0), LKST_ARG (0));
	retv = real_ops->socket_sock_rcv_skb (sk, skb);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_SOCK_RCV_SKB, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_socket_getpeersec (struct socket *sock, char __user * optval,
			    int __user * optlen, unsigned len)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_GETPEERSEC, LKST_ARGP (sock),
		   LKST_ARGP (optval), LKST_ARGP (optlen), LKST_ARG (len));
	retv = real_ops->socket_getpeersec (sock, optval, optlen, len);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SOCKET_GETPEERSEC, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static int
lkst_lsm_sk_alloc_security (struct sock *sk, int family, int priority)
{
	int retv;
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SK_ALLOC_SECURITY, LKST_ARGP (sk),
		   LKST_ARG (family), LKST_ARG (priority), LKST_ARG (0));
	retv = real_ops->sk_alloc_security (sk, family, priority);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SK_ALLOC_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (retv));
	return retv;
}

static void
lkst_lsm_sk_free_security (struct sock *sk)
{
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SK_FREE_SECURITY, LKST_ARGP (sk),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	real_ops->sk_free_security (sk);
	LKST_HOOK_INLINE (LKST_ETYPE_LSM_SK_FREE_SECURITY, LKST_ARG (0),
		   LKST_ARG (0), LKST_ARG (0), LKST_ARG (0));
	return;
}
#endif

/*security operation call vector*/
struct security_operations lkst_lsm_ops = {
	.ptrace = lkst_lsm_ptrace,
	.capget = lkst_lsm_capget,
	.capset_check = lkst_lsm_capset_check,
	.capset_set = lkst_lsm_capset_set,
	.acct = lkst_lsm_acct,
	.sysctl = lkst_lsm_sysctl,
	.capable = lkst_lsm_capable,
	.quotactl = lkst_lsm_quotactl,
	.quota_on = lkst_lsm_quota_on,
	.syslog = lkst_lsm_syslog,
	.vm_enough_memory = lkst_lsm_vm_enough_memory,
	.bprm_alloc_security = lkst_lsm_bprm_alloc_security,
	.bprm_free_security = lkst_lsm_bprm_free_security,
	.bprm_apply_creds = lkst_lsm_bprm_apply_creds,
	.bprm_set_security = lkst_lsm_bprm_set_security,
	.bprm_check_security = lkst_lsm_bprm_check_security,
	.bprm_secureexec = lkst_lsm_bprm_secureexec,
	.sb_alloc_security = lkst_lsm_sb_alloc_security,
	.sb_free_security = lkst_lsm_sb_free_security,
	.sb_copy_data = lkst_lsm_sb_copy_data,
	.sb_kern_mount = lkst_lsm_sb_kern_mount,
	.sb_statfs = lkst_lsm_sb_statfs,
	.sb_mount = lkst_lsm_sb_mount,
	.sb_check_sb = lkst_lsm_sb_check_sb,
	.sb_umount = lkst_lsm_sb_umount,
	.sb_umount_close = lkst_lsm_sb_umount_close,
	.sb_umount_busy = lkst_lsm_sb_umount_busy,
	.sb_post_remount = lkst_lsm_sb_post_remount,
	.sb_post_mountroot = lkst_lsm_sb_post_mountroot,
	.sb_post_addmount = lkst_lsm_sb_post_addmount,
	.sb_pivotroot = lkst_lsm_sb_pivotroot,
	.sb_post_pivotroot = lkst_lsm_sb_post_pivotroot,
	.inode_alloc_security = lkst_lsm_inode_alloc_security,
	.inode_free_security = lkst_lsm_inode_free_security,
	.inode_create = lkst_lsm_inode_create,
	.inode_post_create = lkst_lsm_inode_post_create,
	.inode_link = lkst_lsm_inode_link,
	.inode_post_link = lkst_lsm_inode_post_link,
	.inode_unlink = lkst_lsm_inode_unlink,
	.inode_symlink = lkst_lsm_inode_symlink,
	.inode_post_symlink = lkst_lsm_inode_post_symlink,
	.inode_mkdir = lkst_lsm_inode_mkdir,
	.inode_post_mkdir = lkst_lsm_inode_post_mkdir,
	.inode_rmdir = lkst_lsm_inode_rmdir,
	.inode_mknod = lkst_lsm_inode_mknod,
	.inode_post_mknod = lkst_lsm_inode_post_mknod,
	.inode_rename = lkst_lsm_inode_rename,
	.inode_post_rename = lkst_lsm_inode_post_rename,
	.inode_readlink = lkst_lsm_inode_readlink,
	.inode_follow_link = lkst_lsm_inode_follow_link,
	.inode_permission = lkst_lsm_inode_permission,
	.inode_setattr = lkst_lsm_inode_setattr,
	.inode_getattr = lkst_lsm_inode_getattr,
	.inode_delete = lkst_lsm_inode_delete,
	.inode_setxattr = lkst_lsm_inode_setxattr,
	.inode_post_setxattr = lkst_lsm_inode_post_setxattr,
	.inode_getxattr = lkst_lsm_inode_getxattr,
	.inode_listxattr = lkst_lsm_inode_listxattr,
	.inode_removexattr = lkst_lsm_inode_removexattr,
	.inode_getsecurity = lkst_lsm_inode_getsecurity,
	.inode_setsecurity = lkst_lsm_inode_setsecurity,
	.inode_listsecurity = lkst_lsm_inode_listsecurity,
	.file_permission = lkst_lsm_file_permission,
	.file_alloc_security = lkst_lsm_file_alloc_security,
	.file_free_security = lkst_lsm_file_free_security,
	.file_ioctl = lkst_lsm_file_ioctl,
	.file_mmap = lkst_lsm_file_mmap,
	.file_mprotect = lkst_lsm_file_mprotect,
	.file_lock = lkst_lsm_file_lock,
	.file_fcntl = lkst_lsm_file_fcntl,
	.file_set_fowner = lkst_lsm_file_set_fowner,
	.file_send_sigiotask = lkst_lsm_file_send_sigiotask,
	.file_receive = lkst_lsm_file_receive,
	.task_create = lkst_lsm_task_create,
	.task_alloc_security = lkst_lsm_task_alloc_security,
	.task_free_security = lkst_lsm_task_free_security,
	.task_setuid = lkst_lsm_task_setuid,
	.task_post_setuid = lkst_lsm_task_post_setuid,
	.task_setgid = lkst_lsm_task_setgid,
	.task_setpgid = lkst_lsm_task_setpgid,
	.task_getpgid = lkst_lsm_task_getpgid,
	.task_getsid = lkst_lsm_task_getsid,
	.task_setgroups = lkst_lsm_task_setgroups,
	.task_setnice = lkst_lsm_task_setnice,
	.task_setrlimit = lkst_lsm_task_setrlimit,
	.task_setscheduler = lkst_lsm_task_setscheduler,
	.task_getscheduler = lkst_lsm_task_getscheduler,
	.task_kill = lkst_lsm_task_kill,
	.task_wait = lkst_lsm_task_wait,
	.task_prctl = lkst_lsm_task_prctl,
	.task_reparent_to_init = lkst_lsm_task_reparent_to_init,
	.task_to_inode = lkst_lsm_task_to_inode,
	.ipc_permission = lkst_lsm_ipc_permission,
	.msg_msg_alloc_security = lkst_lsm_msg_msg_alloc_security,
	.msg_msg_free_security = lkst_lsm_msg_msg_free_security,
	.msg_queue_alloc_security = lkst_lsm_msg_queue_alloc_security,
	.msg_queue_free_security = lkst_lsm_msg_queue_free_security,
	.msg_queue_associate = lkst_lsm_msg_queue_associate,
	.msg_queue_msgctl = lkst_lsm_msg_queue_msgctl,
	.msg_queue_msgsnd = lkst_lsm_msg_queue_msgsnd,
	.msg_queue_msgrcv = lkst_lsm_msg_queue_msgrcv,
	.shm_alloc_security = lkst_lsm_shm_alloc_security,
	.shm_free_security = lkst_lsm_shm_free_security,
	.shm_associate = lkst_lsm_shm_associate,
	.shm_shmctl = lkst_lsm_shm_shmctl,
	.shm_shmat = lkst_lsm_shm_shmat,
	.sem_alloc_security = lkst_lsm_sem_alloc_security,
	.sem_free_security = lkst_lsm_sem_free_security,
	.sem_associate = lkst_lsm_sem_associate,
	.sem_semctl = lkst_lsm_sem_semctl,
	.sem_semop = lkst_lsm_sem_semop,
	.netlink_send = lkst_lsm_netlink_send,
	.netlink_recv = lkst_lsm_netlink_recv,
	.register_security = lkst_lsm_register_security,
	.unregister_security = lkst_lsm_unregister_security,
	.d_instantiate = lkst_lsm_d_instantiate,
	.getprocattr = lkst_lsm_getprocattr,
	.setprocattr = lkst_lsm_setprocattr,
#ifdef CONFIG_SECURITY_NETWORK
	.unix_stream_connect = lkst_lsm_unix_stream_connect,
	.unix_may_send = lkst_lsm_unix_may_send,
	.socket_create = lkst_lsm_socket_create,
	.socket_post_create = lkst_lsm_socket_post_create,
	.socket_bind = lkst_lsm_socket_bind,
	.socket_connect = lkst_lsm_socket_connect,
	.socket_listen = lkst_lsm_socket_listen,
	.socket_accept = lkst_lsm_socket_accept,
	.socket_post_accept = lkst_lsm_socket_post_accept,
	.socket_sendmsg = lkst_lsm_socket_sendmsg,
	.socket_recvmsg = lkst_lsm_socket_recvmsg,
	.socket_getsockname = lkst_lsm_socket_getsockname,
	.socket_getpeername = lkst_lsm_socket_getpeername,
	.socket_getsockopt = lkst_lsm_socket_getsockopt,
	.socket_setsockopt = lkst_lsm_socket_setsockopt,
	.socket_shutdown = lkst_lsm_socket_shutdown,
	.socket_sock_rcv_skb = lkst_lsm_socket_sock_rcv_skb,
	.socket_getpeersec = lkst_lsm_socket_getpeersec,
	.sk_alloc_security = lkst_lsm_sk_alloc_security,
	.sk_free_security = lkst_lsm_sk_free_security,
#endif
};

struct lkst_etype_info *lkst_lsm_infos[LKST_LSM_OPS_NUM] = {
	[0] = &LKST_ETYPE_INFO (LSM_PTRACE),
	[1] = &LKST_ETYPE_INFO (LSM_CAPGET),
	[2] = &LKST_ETYPE_INFO (LSM_CAPSET_CHECK),
	[3] = &LKST_ETYPE_INFO (LSM_CAPSET_SET),
	[4] = &LKST_ETYPE_INFO (LSM_ACCT),
	[5] = &LKST_ETYPE_INFO (LSM_SYSCTL),
	[6] = &LKST_ETYPE_INFO (LSM_CAPABLE),
	[7] = &LKST_ETYPE_INFO (LSM_QUOTACTL),
	[8] = &LKST_ETYPE_INFO (LSM_QUOTA_ON),
	[9] = &LKST_ETYPE_INFO (LSM_SYSLOG),
	[10] = &LKST_ETYPE_INFO (LSM_VM_ENOUGH_MEMORY),
	[11] = &LKST_ETYPE_INFO (LSM_BPRM_ALLOC_SECURITY),
	[12] = &LKST_ETYPE_INFO (LSM_BPRM_FREE_SECURITY),
	[13] = &LKST_ETYPE_INFO (LSM_BPRM_APPLY_CREDS),
	[14] = &LKST_ETYPE_INFO (LSM_BPRM_SET_SECURITY),
	[15] = &LKST_ETYPE_INFO (LSM_BPRM_CHECK_SECURITY),
	[16] = &LKST_ETYPE_INFO (LSM_BPRM_SECUREEXEC),
	[17] = &LKST_ETYPE_INFO (LSM_SB_ALLOC_SECURITY),
	[18] = &LKST_ETYPE_INFO (LSM_SB_FREE_SECURITY),
	[19] = &LKST_ETYPE_INFO (LSM_SB_COPY_DATA),
	[20] = &LKST_ETYPE_INFO (LSM_SB_KERN_MOUNT),
	[21] = &LKST_ETYPE_INFO (LSM_SB_STATFS),
	[22] = &LKST_ETYPE_INFO (LSM_SB_MOUNT),
	[23] = &LKST_ETYPE_INFO (LSM_SB_CHECK_SB),
	[24] = &LKST_ETYPE_INFO (LSM_SB_UMOUNT),
	[25] = &LKST_ETYPE_INFO (LSM_SB_UMOUNT_CLOSE),
	[26] = &LKST_ETYPE_INFO (LSM_SB_UMOUNT_BUSY),
	[27] = &LKST_ETYPE_INFO (LSM_SB_POST_REMOUNT),
	[28] = &LKST_ETYPE_INFO (LSM_SB_POST_MOUNTROOT),
	[29] = &LKST_ETYPE_INFO (LSM_SB_POST_ADDMOUNT),
	[30] = &LKST_ETYPE_INFO (LSM_SB_PIVOTROOT),
	[31] = &LKST_ETYPE_INFO (LSM_SB_POST_PIVOTROOT),
	[32] = &LKST_ETYPE_INFO (LSM_INODE_ALLOC_SECURITY),
	[33] = &LKST_ETYPE_INFO (LSM_INODE_FREE_SECURITY),
	[34] = &LKST_ETYPE_INFO (LSM_INODE_CREATE),
	[35] = &LKST_ETYPE_INFO (LSM_INODE_POST_CREATE),
	[36] = &LKST_ETYPE_INFO (LSM_INODE_LINK),
	[37] = &LKST_ETYPE_INFO (LSM_INODE_POST_LINK),
	[38] = &LKST_ETYPE_INFO (LSM_INODE_UNLINK),
	[39] = &LKST_ETYPE_INFO (LSM_INODE_SYMLINK),
	[40] = &LKST_ETYPE_INFO (LSM_INODE_POST_SYMLINK),
	[41] = &LKST_ETYPE_INFO (LSM_INODE_MKDIR),
	[42] = &LKST_ETYPE_INFO (LSM_INODE_POST_MKDIR),
	[43] = &LKST_ETYPE_INFO (LSM_INODE_RMDIR),
	[44] = &LKST_ETYPE_INFO (LSM_INODE_MKNOD),
	[45] = &LKST_ETYPE_INFO (LSM_INODE_POST_MKNOD),
	[46] = &LKST_ETYPE_INFO (LSM_INODE_RENAME),
	[47] = &LKST_ETYPE_INFO (LSM_INODE_POST_RENAME),
	[48] = &LKST_ETYPE_INFO (LSM_INODE_READLINK),
	[49] = &LKST_ETYPE_INFO (LSM_INODE_FOLLOW_LINK),
	[50] = &LKST_ETYPE_INFO (LSM_INODE_PERMISSION),
	[51] = &LKST_ETYPE_INFO (LSM_INODE_SETATTR),
	[52] = &LKST_ETYPE_INFO (LSM_INODE_GETATTR),
	[53] = &LKST_ETYPE_INFO (LSM_INODE_DELETE),
	[54] = &LKST_ETYPE_INFO (LSM_INODE_SETXATTR),
	[55] = &LKST_ETYPE_INFO (LSM_INODE_POST_SETXATTR),
	[56] = &LKST_ETYPE_INFO (LSM_INODE_GETXATTR),
	[57] = &LKST_ETYPE_INFO (LSM_INODE_LISTXATTR),
	[58] = &LKST_ETYPE_INFO (LSM_INODE_REMOVEXATTR),
	[59] = &LKST_ETYPE_INFO (LSM_INODE_GETSECURITY),
	[60] = &LKST_ETYPE_INFO (LSM_INODE_SETSECURITY),
	[61] = &LKST_ETYPE_INFO (LSM_INODE_LISTSECURITY),
	[62] = &LKST_ETYPE_INFO (LSM_FILE_PERMISSION),
	[63] = &LKST_ETYPE_INFO (LSM_FILE_ALLOC_SECURITY),
	[64] = &LKST_ETYPE_INFO (LSM_FILE_FREE_SECURITY),
	[65] = &LKST_ETYPE_INFO (LSM_FILE_IOCTL),
	[66] = &LKST_ETYPE_INFO (LSM_FILE_MMAP),
	[67] = &LKST_ETYPE_INFO (LSM_FILE_MPROTECT),
	[68] = &LKST_ETYPE_INFO (LSM_FILE_LOCK),
	[69] = &LKST_ETYPE_INFO (LSM_FILE_FCNTL),
	[70] = &LKST_ETYPE_INFO (LSM_FILE_SET_FOWNER),
	[71] = &LKST_ETYPE_INFO (LSM_FILE_SEND_SIGIOTASK),
	[72] = &LKST_ETYPE_INFO (LSM_FILE_RECEIVE),
	[73] = &LKST_ETYPE_INFO (LSM_TASK_CREATE),
	[74] = &LKST_ETYPE_INFO (LSM_TASK_ALLOC_SECURITY),
	[75] = &LKST_ETYPE_INFO (LSM_TASK_FREE_SECURITY),
	[76] = &LKST_ETYPE_INFO (LSM_TASK_SETUID),
	[77] = &LKST_ETYPE_INFO (LSM_TASK_POST_SETUID),
	[78] = &LKST_ETYPE_INFO (LSM_TASK_SETGID),
	[79] = &LKST_ETYPE_INFO (LSM_TASK_SETPGID),
	[80] = &LKST_ETYPE_INFO (LSM_TASK_GETPGID),
	[81] = &LKST_ETYPE_INFO (LSM_TASK_GETSID),
	[82] = &LKST_ETYPE_INFO (LSM_TASK_SETGROUPS),
	[83] = &LKST_ETYPE_INFO (LSM_TASK_SETNICE),
	[84] = &LKST_ETYPE_INFO (LSM_TASK_SETRLIMIT),
	[85] = &LKST_ETYPE_INFO (LSM_TASK_SETSCHEDULER),
	[86] = &LKST_ETYPE_INFO (LSM_TASK_GETSCHEDULER),
	[87] = &LKST_ETYPE_INFO (LSM_TASK_KILL),
	[88] = &LKST_ETYPE_INFO (LSM_TASK_WAIT),
	[89] = &LKST_ETYPE_INFO (LSM_TASK_PRCTL),
	[90] = &LKST_ETYPE_INFO (LSM_TASK_REPARENT_TO_INIT),
	[91] = &LKST_ETYPE_INFO (LSM_TASK_TO_INODE),
	[92] = &LKST_ETYPE_INFO (LSM_IPC_PERMISSION),
	[93] = &LKST_ETYPE_INFO (LSM_MSG_MSG_ALLOC_SECURITY),
	[94] = &LKST_ETYPE_INFO (LSM_MSG_MSG_FREE_SECURITY),
	[95] = &LKST_ETYPE_INFO (LSM_MSG_QUEUE_ALLOC_SECURITY),
	[96] = &LKST_ETYPE_INFO (LSM_MSG_QUEUE_FREE_SECURITY),
	[97] = &LKST_ETYPE_INFO (LSM_MSG_QUEUE_ASSOCIATE),
	[98] = &LKST_ETYPE_INFO (LSM_MSG_QUEUE_MSGCTL),
	[99] = &LKST_ETYPE_INFO (LSM_MSG_QUEUE_MSGSND),
	[100] = &LKST_ETYPE_INFO (LSM_MSG_QUEUE_MSGRCV),
	[101] = &LKST_ETYPE_INFO (LSM_SHM_ALLOC_SECURITY),
	[102] = &LKST_ETYPE_INFO (LSM_SHM_FREE_SECURITY),
	[103] = &LKST_ETYPE_INFO (LSM_SHM_ASSOCIATE),
	[104] = &LKST_ETYPE_INFO (LSM_SHM_SHMCTL),
	[105] = &LKST_ETYPE_INFO (LSM_SHM_SHMAT),
	[106] = &LKST_ETYPE_INFO (LSM_SEM_ALLOC_SECURITY),
	[107] = &LKST_ETYPE_INFO (LSM_SEM_FREE_SECURITY),
	[108] = &LKST_ETYPE_INFO (LSM_SEM_ASSOCIATE),
	[109] = &LKST_ETYPE_INFO (LSM_SEM_SEMCTL),
	[110] = &LKST_ETYPE_INFO (LSM_SEM_SEMOP),
	[111] = &LKST_ETYPE_INFO (LSM_NETLINK_SEND),
	[112] = &LKST_ETYPE_INFO (LSM_NETLINK_RECV),
	[113] = &LKST_ETYPE_INFO (LSM_REGISTER_SECURITY),
	[114] = &LKST_ETYPE_INFO (LSM_UNREGISTER_SECURITY),
	[115] = &LKST_ETYPE_INFO (LSM_D_INSTANTIATE),
	[116] = &LKST_ETYPE_INFO (LSM_GETPROCATTR),
	[117] = &LKST_ETYPE_INFO (LSM_SETPROCATTR),
#ifdef CONFIG_SECURITY_NETWORK
	[118] = &LKST_ETYPE_INFO (LSM_UNIX_STREAM_CONNECT),
	[119] = &LKST_ETYPE_INFO (LSM_UNIX_MAY_SEND),
	[120] = &LKST_ETYPE_INFO (LSM_SOCKET_CREATE),
	[121] = &LKST_ETYPE_INFO (LSM_SOCKET_POST_CREATE),
	[122] = &LKST_ETYPE_INFO (LSM_SOCKET_BIND),
	[123] = &LKST_ETYPE_INFO (LSM_SOCKET_CONNECT),
	[124] = &LKST_ETYPE_INFO (LSM_SOCKET_LISTEN),
	[125] = &LKST_ETYPE_INFO (LSM_SOCKET_ACCEPT),
	[126] = &LKST_ETYPE_INFO (LSM_SOCKET_POST_ACCEPT),
	[127] = &LKST_ETYPE_INFO (LSM_SOCKET_SENDMSG),
	[128] = &LKST_ETYPE_INFO (LSM_SOCKET_RECVMSG),
	[129] = &LKST_ETYPE_INFO (LSM_SOCKET_GETSOCKNAME),
	[130] = &LKST_ETYPE_INFO (LSM_SOCKET_GETPEERNAME),
	[131] = &LKST_ETYPE_INFO (LSM_SOCKET_GETSOCKOPT),
	[132] = &LKST_ETYPE_INFO (LSM_SOCKET_SETSOCKOPT),
	[133] = &LKST_ETYPE_INFO (LSM_SOCKET_SHUTDOWN),
	[134] = &LKST_ETYPE_INFO (LSM_SOCKET_SOCK_RCV_SKB),
	[135] = &LKST_ETYPE_INFO (LSM_SOCKET_GETPEERSEC),
	[136] = &LKST_ETYPE_INFO (LSM_SK_ALLOC_SECURITY),
	[137] = &LKST_ETYPE_INFO (LSM_SK_FREE_SECURITY),
#endif
};
