/*
 syscall time distribution analyer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <syscalls.h>

static slot_hkey info_key_syscall(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_syscall(struct lkst_log_record *rec);
static char * get_alias_syscall(slot_hkey key);
static ga_type_t get_type_syscall(struct lkst_log_record *rec);

struct gate_analyzer syscall_analyzer = {
	.name = "syscall",
	.description = "System call analyzer",
	.title = "sysno       syscall_name",
	.format_data = "%5d %18s",
	.delta_title = "processing-time",

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID
	GA_INIT_NO_EXTRAOPTS

	.info_key = info_key_syscall,
	.session_key = session_key_syscall,
	.get_alias = get_alias_syscall,
	.get_type = get_type_syscall,

	.init = init_none,
};

static slot_hkey info_key_syscall(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	return (rec->log_arg1 & 0xffffffff);
}
static slot_hkey session_key_syscall(struct lkst_log_record *rec)
{
	return ((rec->posix.log_pid & 0x7fffff) | 
		((rec->log_arg1 & 0xffffffff)<<23)) ;
}

static char * get_alias_syscall(slot_hkey key)
{
	if (key > NR_syscalls || syscall_name[key]==NULL)
		return "(unknown)";
	else 
		return syscall_name[key];
}

static ga_type_t get_type_syscall(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type) {
	case 0x30:
	case 0x32:
		return GAT_START;
	case 0x31:
	case 0x33:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
