/*
 scheduler time distribution/runqueue analyer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <string.h>

static slot_hkey info_key_schedrun(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_schedrun(struct lkst_log_record *rec);
static char * get_alias_schedrun(slot_hkey key);
static ga_type_t get_type_schedrun(struct lkst_log_record *rec);
static int init_schedrun(void);

struct gate_analyzer schedrun_analyzer = {
	.name = "schedrun",
	.description = "scheduler overhead per runqueue-len analyzer",
	.title = " len        runqueue",
	.format_data = "%4d %16s",
	.delta_title = "scheduling-time",

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID
	GA_INIT_NO_EXTRAOPTS
		
	.info_key = info_key_schedrun,
	.session_key = session_key_schedrun,
	.get_alias = get_alias_schedrun,

	.get_type = get_type_schedrun,

	.init = init_schedrun,
};

static generic_slots_t *gsl_info=NULL;

static int init_schedrun(void)
{
	gsl_info = new_generic_slots(5,20);
	if (gsl_info == NULL)return -ENOMEM;
	return 0;
}

static slot_hkey info_key_schedrun(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	slot_hkey key = rec_start->log_arg2&0xffffffff;
	if (find_slot(gsl_info, key) == NULL) {
		slot_t *s;
		s = get_free_slot(gsl_info,key);
		if (s) { 
			snprintf((char*)slot_data(s),16,"rq-%d",key);
		}
	}
	return key;
}
static slot_hkey session_key_schedrun(struct lkst_log_record *rec)
{
	return rec->posix.log_pid;
}

static char * get_alias_schedrun(slot_hkey key)
{
	slot_t *s = find_slot(gsl_info, key);
	if (s) {
		return (char *)slot_data(s);
	}else
		return "(unknown)";
}
static ga_type_t get_type_schedrun(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type) {
	case LKST_ETYPE_PROCESS_SCHED_ENTER:
		return GAT_START;
	case LKST_ETYPE_PROCESS_SCHED_EXIT:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
