/*
 LKST statistics formatter

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <lkstla.h>

static int pre_analyze_stat(struct gate_analyzer *ga);
static void callback_stat(struct gate_analyzer *ga, slot_hkey key,
			  struct timespec *ets, double delta, int pid);
static void post_analyze_stat(struct gate_analyzer *ga);
static int opt_handler_stat(int c, char *opt);

struct analysis_formatter stat_formatter = {
        .opt = { 
		.opt = "s",
		.format = "-s",
		.description = "show statistics",
		.handler = opt_handler_stat,
	},
	.active = 0,
	.pre_analyze = pre_analyze_stat,
	.callback = callback_stat,
	.post_analyze = post_analyze_stat,
};

struct stat_data {
	double total, max, min;
	int count;
	int failed;
};

#define SYS_HASH_BITS 6
static generic_slots_t *gsl_stat = NULL;

static int pre_analyze_stat(struct gate_analyzer *ga)
{
	gsl_stat = new_generic_slots_sorted(SYS_HASH_BITS, sizeof(struct stat_data));
	if (gsl_stat == NULL) {
		printf("error: fail to memory allocation\n");
		return -1;
	}
	printf("%s\n",ga->description);
	printf("%s %10s %15s %15s %15s\n",ga->title,"count","average","max","min");
	return 0;
}

static void callback_stat(struct gate_analyzer *ga, slot_hkey key,
			  struct timespec *ets, double delta, int pid)
{
	struct stat_data *stat;
	slot_t *slot;
	slot = find_slot(gsl_stat, key);
	if (slot == NULL) slot = get_free_slot(gsl_stat, key);
	if (slot != NULL)  {
		stat = (struct stat_data *)slot_data(slot);
		stat->total += delta;
		if (stat->max < delta)
			stat->max=delta;
		if (delta < stat->min || 
		    stat->count==0 /*first time*/ )
			stat->min=delta;
		stat->count ++;
	}
}

static void post_analyze_stat(struct gate_analyzer *ga)
{
	slot_hkey key;
	slot_t *slot;
	struct stat_data * stat;

	for_each_sorted_slot(gsl_stat,slot) {
		double avg;
		key = slot->key;
		stat = (struct stat_data *)slot_data(slot);
		printf(ga->format_data, key, ga->get_alias(key));
		printf(" %10d",stat->count);
		avg = stat->total;
		if(stat->count) avg /= stat->count;
		printf(" %15.9f %15.9f %15.9f\n",
		       avg, stat->max, stat->min);
	}
	free_generic_slots(gsl_stat);
	return ;
}

static int opt_handler_stat(int c, char *opt)
{
	stat_formatter.active = 1;
	return 0;
}

