/*
 LKST log formatter

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <lkstla.h>

static int pre_analyze_log(struct gate_analyzer *ga);
static void callback_log(struct gate_analyzer *ga, slot_hkey key,
			 struct timespec *ets, double delta,int pid);
static void post_analyze_log(struct gate_analyzer *ga);
static int opt_handler_log(int c, char *opt);

struct analysis_formatter log_formatter = {
        .opt = { 
		.opt = "l::",
		.format = "-l[p]",
		.description = "show logs. if p=1, show pid with logs.",
		.handler = opt_handler_log,
	},
	.active = 0,
	.pre_analyze = pre_analyze_log,
	.callback = callback_log,
	.post_analyze = post_analyze_log,
};

static int pid_show=0;

static int opt_handler_log(int c, char *opt)
{
	if (opt && atoi(opt)) pid_show=1;
	log_formatter.active = 1;
	return 0;
}

static int pre_analyze_log(struct gate_analyzer *ga)
{
	printf("%s\n",ga->description);
	printf("%s%s %20s %15s\n",ga->title,(pid_show)?"   pid":"",
	       "start[sec]", ga->delta_title);
	return 0;
}
static void callback_log(struct gate_analyzer *ga, slot_hkey key,
			 struct timespec *ets, double delta, int pid)
{
	printf(ga->format_data, key, ga->get_alias(key));
	if (pid_show) {
		printf(" %5d",pid);
	}
	printf(" %10lu.%09lu", ets->tv_sec, ets->tv_nsec);
	printf(" %15.9f\n", delta);
}
static void post_analyze_log(struct gate_analyzer *ga)
{
	return ;
}

