/*
 buffer head flushing analyzer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>

static slot_hkey info_key_buffer(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_buffer(struct lkst_log_record *rec);
static char * get_alias_buffer(slot_hkey key);
static ga_type_t get_type_buffer(struct lkst_log_record *rec);

struct gate_analyzer buffer_analyzer = {
	.name = "buffer",
	.description = "buffer head flushing analyzer",
	.title = "type buffer-method",
	.format_data = "%4d %13s",
	.delta_title = "bufferio-time",

	GA_INIT_SESSION_ANALYZER
	GA_INIT_NO_EXTRAOPTS
	GA_INIT_1TO1_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_buffer,
	.session_key = session_key_buffer,
	.get_alias = get_alias_buffer,

	.get_type = get_type_buffer,

	.init = init_none,
};

static char *buffer_name[] = {
	[0]="read",
	[1]="write",
	[2]="read ahead",
	[3]="write ahead",
	[4]="read barrier",
	[5]="write barrier",
	[8]="read failfast",
	[9]="write failfast",
	[16]="read sync",
	[17]="write sync",
};
#define NR_buffers 18

static slot_hkey info_key_buffer(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end)
{
	return rec_start->log_arg3 & 0xffffffff;
}
static slot_hkey session_key_buffer(struct lkst_log_record *rec)
{
	return ((unsigned)rec->log_arg1 ^ rec->log_arg2 )& 0xffffffff;
}

static char * get_alias_buffer(slot_hkey key)
{
	if(key>=NR_buffers)
		return "(unknown)";
	else
		return buffer_name[key];
}

static ga_type_t get_type_buffer(struct lkst_log_record *rec)
{
	switch (rec->posix.log_event_type) {
	case LKST_ETYPE_BUFFER_SUBMIT_BH:
		return GAT_START;
	case LKST_ETYPE_BUFFER_ENDIO_BH:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
