.TH lkstla 8
.SH NAME
lkstla \- LKST event log analyzer
.br
.SH SYNOPSIS
lkstla \fI<analyzer>\fR [ \fIformat\fR ] [ \fIoption(s)\fR ] logfile [...]
.SH DESCRIPTION
lkstla analyze variable events traced by LKST. 
.SH ANALYZERS
.TP
\fBsyscall
.br
Analyze system call processing time.
.TP
\fBsoftirq
.br
Analyze software-irq delay-time.
.TP
\fBtimer [ \-S \fIksyms\fR ]
.br
Analyze timer-handler execution delay-time.
.TP
\fBpalloc
.br
Analyze page allocation processing time.
.TP
\fBvmscan\ \ 
.br
Analyze page reclaiming time.
.TP
\fBevent  [ \-E \fIetypes_list\fR ]
.br
Analyze logged events.
.TP
\fBbuffer
.br
Analyze buffer-head I/O time
.TP
\fBblkqueue
.br
Analyze the length of request queue in block layer.
.TP
\fBbiotime\ \ 
.br
Analyze BIO processing time.
.TP
\fBspinlock [ \-S \fIksyms\fR ]
.br
Analyze spinlock locking time.
.TP
\fBbusywait [ \-S \fIksyms\fR ]
.br
Analyze spinlock lock-contention time.
.TP
\fBwaittime [ \-S \fIksyms\fR ]
.br
Analyze wait-queue waiting time.
.TP
\fBrunqueue
.br
Analyze the length of runqueue.
.TP
\fBschedule
.br
Analyze scheduling time by process.
.TP
\fBschedrun
.br
Analyze scheduling time by runqueue length.
.TP
\fBwaitqueue [ \-S \fIksyms\fR ]
.br
Analyze the length of waitqueue.
.TP
\fBnetroute
.br
Analyze network-routing processing time.
.TP
\fBnetsend
.br
Analyze packet send delay time.
.TP
\fBprocstat
.br
Analyze process status
.TP
\fBproclive
.br
Analyze process living time


.SH FORMATS
.TP 1i
.B \ \ \ \ \ \ \-l[pidflag]
Show results as log format. If pidflag = 1, show pid. (DEFAULT Format)
.TP 1i
.B \ \ \ \ \ \ \-s
Show results as statistics.
.TP 1i
.B \ \ \ \ \ \ \-d[[\fImin\fR]:[\fImax\fR]:[\fIrank\fR]:[\fIlogscale\fR]]
Show results as distributions.
		     
.SH OPTIONS
.TP 1i
.B \ \ \ \ \ \ \-h
Show help message.
.TP 1i
.B \ \ \ \ \ \ \-p<\fIpid\fR[,\fIpid\fR[...]]> 
Set pid filter.
.TP 1i
.B \ \ \ \ \ \ \-t<\fIstart\fR[+\fIspan\fR|:\fIspan\fR][,...]>
Set time filter.
	     

.SH RETURN VALUE
.TP
.B 0
success
.TP
.B Except 0
failure
.SH AUTHOR
Masami Hiramatsu <hiramatu@sdl.hitachi.co.jp>
