/*
 timespec macros
  
 Copyright (C) HITACHI,LTD. 2004
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */
/*timespec sub-routines*/

#define NSEC_PER_SEC (1000*1000*1000)
/*
 * macro: timespec_inc
 * desc: add the value of timespec to another.
 * args: orig -- original timespec valuable.
 *       diff -- timespec value to add to orig.
 */
#define timespec_inc(orig, diff) { \
	orig.tv_sec += diff.tv_sec; \
	orig.tv_nsec += diff.tv_nsec; \
	while (orig.tv_nsec > NSEC_PER_SEC) { \
		orig.tv_sec ++; \
		orig.tv_nsec -= NSEC_PER_SEC; } }

/*
 * macro: timespec_dec
 * desc: decrement the value of timespec from another.
 * args: orig -- original timespec valuable.
 *       diff -- timespec value to decrement from orig.
 */
#define timespec_dec(orig, diff) { \
	orig.tv_sec -= diff.tv_sec; \
	orig.tv_nsec -= diff.tv_nsec; \
	while (orig.tv_nsec < 0 && orig.tv_sec > 0) { \
		orig.tv_sec --; \
		orig.tv_nsec += NSEC_PER_SEC; } }

/*
 * macro: timespec_lt
 * desc: compare 2 timespecs, and check whether "a" is less than "b".
 * args: a -- timespec
 *       b -- timespec
 * retval: (true)  -- a is less than b (a < b)
 *         (fales) -- a is not less than b (a >= b)
 */
#define timespec_lt(a,b) \
	(((a).tv_sec < (b).tv_sec) || \
		 ((a).tv_sec == (b).tv_sec && (a).tv_nsec < (b).tv_nsec) )

#define timespec_le(a,b) (timespec_lt(a,b) || \
		  ((a).tv_sec == (b).tv_sec && (a).tv_nsec == (b).tv_nsec ))
/*
 * macro: ts2d
 * desc: convert timespec to double[sec]
 * args: ts -- timespec
 * retval: converted value
 */
#define ts2d(ts)  ((double)(ts).tv_sec + ((double)(ts).tv_nsec / NSEC_PER_SEC))

