/*
 logfile.h -- LKST Log file object.

 Copyright (C) HITACHI,LTD. 2004
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */
#ifndef __LOGFILE_H__
#define __LOGFILE_H__

#include <linux/lkst.h>
#include <linux/lkst_buffer.h>

struct lkst_file_header {
	log_header_t head;
	struct posix_log_entry entry;
	int endian;
	int version;
	char arch[LKST_ARCH_NAME_LEN];
	struct lkst_log_record sync_time;
};

typedef struct lkstlogfile {
	FILE *fp;
	struct lkst_log_record entry;
	struct lkst_file_header header;
} lkstlogfile_t;

#define LOGFILE_MAX 128 /* max 128 files */
struct lkstloglist {
	int nr_logfile;
	lkstlogfile_t *logfiles[LOGFILE_MAX];
};

int logfile_read_one(lkstlogfile_t * lfile);
lkstlogfile_t *new_logfile(char *fname);
void close_logfile(lkstlogfile_t *lfile);
int add_loglist(struct lkstloglist * llist, char *fname);
void cleanup_loglist(struct lkstloglist *llist);
struct lkst_log_record * loglist_earliest_entry(struct lkstloglist *llist,
					      struct lkst_log_record *reload);
void logfile_tsc_to_timespec(lkstlogfile_t *lfile, 
			     struct timespec *ts, lkst_tsc_t tsc);

static inline int logfile_including_synctime(lkstlogfile_t *lfile){
	return (lfile !=NULL && 
		lfile->header.sync_time.posix.log_event_type ==
		LKST_ETYPE_LKST_SYNC_TIME);
}

static inline lkstlogfile_t * find_logfile_from_entry (struct lkstloglist *ll, 
						       struct lkst_log_record *rec)
{
	int i;
	for (i=0;i<ll->nr_logfile;i++) {
		if (&(ll->logfiles[i]->entry) == rec) {
			return ll->logfiles[i];
		}
	}
	return NULL;
}

#endif
