/*
 fileio -- do read / write a file
 
 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#define __USE_GNU 1
#include <fcntl.h>
#include <unistd.h>

#define BUF_SIZE 1024*1024*20
#define BUF_SIZE_ALLOC (BUF_SIZE+512)

void usage() {
	printf("Usage: fileio [-l fsize] [-i isize] [-o osize] [-s] [-d] -f file\n");
}

int main(int argc, char *argv[])
{
	char *buf,*ptr, fname[256];
	int i,fd,ret,c,flag=0;
	size_t fsize=BUF_SIZE, isize=0, osize=0,remain;

	if (argc<2) {
		printf("Usage: fileio [options] -f filename\n");
		return 0;
	}
	while((c = getopt(argc, argv, "l:i:o:sdf:h")) != EOF) {
		switch(c) {
		case 'l' : // fsize
			fsize = atoi(optarg);
			break;
		case 'i': //isize
			isize = atoi(optarg);
			break;
		case 'o': //osize
			osize = atoi(optarg);
			break;
		case 'f' :
			strncpy(fname,optarg,256);
			break;
		case 's':
			flag |= O_SYNC;
			break;
		case 'd':
			flag |= O_DIRECT;
			break;
		default:
			;
		}
	}
	if (isize==0) {isize=fsize;}
	if (osize==0) {osize=fsize;}
	ptr = malloc(fsize+512);
	buf = (char*)((unsigned long)ptr & 0xfffffe00) + 512;
	
	for (i=0;i<fsize;i++)buf[i]=rand();
	
	fd = open(fname, O_WRONLY|O_CREAT|flag);
	if (fd<0) {
		perror("error on open");
		goto end_io;
	}
	remain = fsize;
	while(remain >= osize) {
		ret = write(fd, buf, osize);
		if (ret<0) {
			perror("error on write");
			goto end_io;
		}
		remain -= osize;
	}
	fsync(fd);
	close(fd);
/*	fprintf(stderr,"sleeping %s\n",argv[1]);
	sleep(5);	
	fprintf(stderr,"wakeup %s\n",argv[1]);
	sleep(5);	*/
	fd = open(fname, O_RDONLY|flag);
	remain = fsize;
	while(remain >= isize) {
		i = read(fd,buf, isize);
		if (ret<0) {
			perror("error on read");
			goto end_io;
		}
		remain -= isize;
	}
	fsync(fd);
	close(fd);
end_io:	
	free(ptr);
//	fprintf(stderr,"exit %s\n",argv[1]);
	return 0;
}
