/*
 softirq delay distribution analyzer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <softirqs.h>

static slot_hkey info_key_softirq(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_softirq(struct lkst_log_record *rec);
static char * get_alias_softirq(slot_hkey key);
static ga_type_t get_type_softirq(struct lkst_log_record *rec);

struct gate_analyzer softirq_analyzer = {
	.name = "softirq",
	.description = "software-irq delayed time analyzer",
	.title = "irqno    softirq_name",
	.format_data = "%5d %15s",
	.delta_title = "delayed-time",

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TO1_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID
	GA_INIT_NO_EXTRAOPTS
		
	.info_key = info_key_softirq,
	.session_key = session_key_softirq,
	.get_alias = get_alias_softirq,

	.get_type = get_type_softirq,

	.init = init_none,
};

static slot_hkey info_key_softirq(struct lkst_log_record *rec_start, struct lkst_log_record *rec) 
{
	return (rec->log_arg1 & 0xffffffff);
}
static slot_hkey session_key_softirq(struct lkst_log_record *rec)
{
	return (rec->log_arg1 & 0xffffffff);
}

static char * get_alias_softirq(slot_hkey key)
{
	if (key > NR_softirqs || softirq_name[key] == NULL)
		return "(unknown)";
	else
		return softirq_name[key];
}

static ga_type_t get_type_softirq(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type) {
	case LKST_ETYPE_SOFTIRQ_RAISE:
		return GAT_START;
	case LKST_ETYPE_SOFTIRQ_ACTION:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
