/*
 Page allcation analyzer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>

static slot_hkey info_key_palloc(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_palloc(struct lkst_log_record *rec);
static char * get_alias_palloc(slot_hkey key);
static ga_type_t get_type_palloc(struct lkst_log_record *rec);

struct gate_analyzer palloc_analyzer = {
	.name = "palloc",
	.description = "page allocator analyzer",
	.title = "order allocation-size",
	.format_data = "%5d %15s",
	.delta_title = "allocating-time",

	GA_INIT_SESSION_ANALYZER
	GA_INIT_NO_EXTRAOPTS
	GA_INIT_1TO1_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_palloc,
	.session_key = session_key_palloc,
	.get_alias = get_alias_palloc,

	.get_type = get_type_palloc,

	.init = init_none,
};

static slot_hkey max_key =0;

static slot_hkey info_key_palloc(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	slot_hkey key = rec->log_arg2 & 0xff;
	if (key > max_key) max_key = key;
	return key;
}
static slot_hkey session_key_palloc(struct lkst_log_record *rec)
{
	return ((rec->posix.log_pid & 0x7fffff) | 
		((rec->log_arg2 & 0xff)<<23)) ;
}

static char * get_alias_palloc(slot_hkey key)
{
	static char buf[17]={0};
	snprintf(buf,16,"%dpages",(1<<key));
	return buf;
}

static ga_type_t get_type_palloc(struct lkst_log_record *rec)
{
	switch (rec->posix.log_event_type){
	case LKST_ETYPE_PAGE_ALLOC_ENTER:
		return GAT_START;
	case LKST_ETYPE_PAGE_ALLOC_EXIT:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
