/*
 network lookup routing table time distribution analyer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <string.h>

static slot_hkey info_key_netroute(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_netroute(struct lkst_log_record *rec);
static char * get_alias_netroute(slot_hkey key);
static ga_type_t get_type_netroute(struct lkst_log_record *rec);
static int init_netroute(void);

struct gate_analyzer netroute_analyzer = {
	.name = "netroute",
	.description = "routing overhead time analyzer",
	.title = "id   type",
	.format_data = "%2d %6s",
	.delta_title = "processing-time",

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID
	GA_INIT_NO_EXTRAOPTS
		
	.info_key = info_key_netroute,
	.session_key = session_key_netroute,
	.get_alias = get_alias_netroute,

	.get_type = get_type_netroute,

	.init = init_netroute,
};


static int init_netroute(void)
{
	return 0;
}

static slot_hkey info_key_netroute(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	return (rec_start->posix.log_event_type == LKST_ETYPE_NET_V4RTOUT_ENTER)?0:1;
}
static slot_hkey session_key_netroute(struct lkst_log_record *rec)
{
	return rec->log_arg2&0xffffffff;
}

static char * get_alias_netroute(slot_hkey key)
{
	return (key==0)?"output":"input";
}
static ga_type_t get_type_netroute(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type) {
	case LKST_ETYPE_NET_V4RTOUT_ENTER:
	case LKST_ETYPE_NET_V4RTIN_ENTER:
		return GAT_START;
	case LKST_ETYPE_NET_V4RTOUT_EXIT:
	case LKST_ETYPE_NET_V4RTIN_EXIT:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
