/*
 lksteh_vminfo -- record vm-zone information handler
  
 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <linux/version.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/lkst_private.h>
#include <linux/wait.h>
#include "../include/extra_etypes.h"

MODULE_AUTHOR("M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>");
MODULE_DESCRIPTION("");
MODULE_LICENSE("GPL");

/* Declaration of hook header */
LKST_ETYPE_DEF_MODULE(EID_MEM_VM_INFO, INLINE, MEM_VM_INFO, "vm information", \
		      "zone", \
		      "free_pages", \
		      "nr_scan_active/inactive",\
		      "nr_active/inactive");
/*for MIRACLE Linux/Red Hat Linux kernel */
/*		      "active_anon/active_cache", \
		      "inactive_dirty/inactive_laundry",\
		      "inactive_clean/free_pages");*/

static int is_gate_in_vmscan(int etype)
{
	return  (etype == LKST_ETYPE_SHRINK_CACHE_ENTER || 
		 etype == LKST_ETYPE_PAGE_AGING_ENTER );
}

#include <linux/mmzone.h>

static void lkst_evhandler_vminfo(void *phookrec, int event_type,
				  lkst_arg_t arg1, lkst_arg_t arg2,
				  lkst_arg_t arg3, lkst_arg_t arg4)
{
	struct zone *_zone;
	preempt_disable();	/*IMPORTANT*/
	if (is_gate_in_vmscan(event_type)) {
		lkst_evhandlerprim_entry_log(event_type, arg1, arg2, arg3, arg4);
		_zone = (struct zone *)((unsigned long)arg1);
		lkst_evhandlerprim_entry_log(LKST_ETYPE_MEM_VM_INFO,
					     LKST_ARGP(_zone), 
					     LKST_ARG32(0,_zone->free_pages),
					     LKST_ARG32(_zone->nr_scan_active,
							_zone->nr_scan_inactive),
					     LKST_ARG32(_zone->nr_active,
							_zone->nr_inactive));
	}
	preempt_enable_no_resched();	/*VERY IMPORTANT*/
}


static int mod_init(void);
static void mod_cleanup(void);
module_init(mod_init);		/*define as initializer*/
module_exit(mod_cleanup);	/*define as terminator*/

static LKST_EH_DEV_DEF(vminfo,
		       lkst_evhandler_vminfo,
		       NULL,NULL,NULL);

static int mod_init(void)
{
	int	retval;
	/* Initialization of hook header */
	retval = lkst_hook_etype_register(&LKST_ETYPE_INFO(MEM_VM_INFO));
	if (retval < 0) {
		printk("lksteh_vminfo: Error: failed to etype register (%d)\n", 
		       retval);
		goto init_err;
	}
	/* register an event handler */
	retval = lkst_eh_device_register(&LKST_EH_DEV(vminfo));
	if (retval < 0) {
		printk("lksteh_vminfo: Error: failed to evhandler register (%d)\n", 
		       retval);
		goto init_err;
	}
	return 0;
	
	init_err:
	mod_cleanup(); /*If occurs an error, invokes terminator.*/
	return retval;
}


static void mod_cleanup(void)
{
	if (LKST_EH_DEV(vminfo).id != LKST_EVHANDLER_ID_VOID) {
		lkst_eh_device_unregister(&LKST_EH_DEV(vminfo));
	}
	lkst_hook_etype_unregister(&LKST_ETYPE_INFO(MEM_VM_INFO));
}
