/*
 hashed list

 Copyright (C) HITACHI,LTD. 2004
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#ifndef __SLOT_H__
#define __SLOT_H__

typedef unsigned int slot_hkey; /*hash key*/

typedef struct __slot_tag {
	slot_hkey key;
	struct __slot_tag * next;
} slot_t;

#define slot_data(slot) (void *)((char *)slot + sizeof(slot_t))

#define GSF_HASHED 0
#define GSF_SORTED 1

typedef struct generic_slots {
	int flag;
	int hash_bits;
	size_t data_size;
	int nr_slots;
	int nr_used_slots;
	slot_t **h_table;
	slot_t *pool;
} generic_slots_t;

#define HASH_TABLE_SIZE(gslot) (1<<gslot->hash_bits)

#define HASH_BITS_MAX 20
#define HASH_BITS_MIN 0  /*linear search*/

#define HKEY_UNUSED 0xffffffff
#define HKEY_DUMMY 0

generic_slots_t * new_generic_slots(int hash_bits, size_t data_size);
static inline generic_slots_t * new_generic_slots_sorted(int hash_bits,
							 size_t data_size){
	generic_slots_t *ret;
	if (NULL != (ret=new_generic_slots(hash_bits,data_size))) {
		ret->flag = GSF_SORTED;
	}
	return ret;
}

int release_all_slots(generic_slots_t * gslot);
int free_generic_slots(generic_slots_t * gslot);
//int shrink_generic_slots(struct generic_slots * gslot);
slot_t * get_free_slot(generic_slots_t * gslot, slot_hkey key);
slot_t * find_slot(generic_slots_t * gslot, slot_hkey key);
int release_slot(generic_slots_t * gslot, slot_hkey key);

/*for sorted slots*/
#define DIR_FORWORD 0
#define DIR_BACKWORD 1
slot_t * find_nearest_slot(generic_slots_t *gslot, slot_hkey key, int dir);

#define for_each_slot(gsl, i, slot) \
	for (i=0; i<(1<<gsl->hash_bits); i++) \
		for(slot = gsl->h_table[i];slot!=NULL; slot=slot->next)

#define for_each_used_slot(gsl, i, slot) \
	for_each_slot(gsl,i,slot) \
		if (slot->key!=HKEY_UNUSED)

#define for_each_sorted_slot(gsl, slot) \
	for (slot=gsl->h_table[0]; gsl->flag == GSF_SORTED && \
		     slot!=NULL; slot=slot->next)


#endif
