/*
 LKST events description loader

 Copyright (C) HITACHI,LTD. 2003-2004
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#ifndef _LKST_EVENTDESC_H_
#define _LKST_EVENTDESC_H_

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/lkst.h>

/*event-type description flag*/
#define LKST_EDF_LOADED 0x10000
#define LKST_EDF_MASKABLE LKST_EF_MASKABLE
#define LKST_EDF_MULTIPLE LKST_EF_MULTIPLE

#define LKST_EDF_NORMAL LKST_EFG_NORMAL
#define LKST_EDF_INLINE LKST_EFG_INLINE
#define LKST_EDF_UNDEF  LKST_EFG_UNDEF
#define LKST_EDF_MODULE LKST_EFG_MODULE
#define LKST_EDF_INTERNAL LKST_EFG_INTERNAL

struct lkst_etype_description {
	char * mnemonic;
	char * name;
	char * args[4];
	int flags;
};
extern struct lkst_etype_description lkst_etype_desc[];
int lkst_etype_desc_load(char * fname);
void lkst_etype_desc_free_all(void);

extern struct command_option edesc_option;
extern int init_eventdesc(void);


#endif
