/*
 cleanup_mem -- cleanup caches
 
 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdlib.h>
#include <stdio.h>

#define BLOCK_MAX (2*1024-1)
#define PAGE_SIZE 4096

int main(int argc, char *argv[])
{
	int i;
	char * ptr;
	size_t size;
	
	if (argc!=2) {printf("usage: cleanup_mem MB-size\n");return 0;}
	
	size = atoi(argv[1]);
	
	if (size>BLOCK_MAX) size=BLOCK_MAX;
	size*=1024*1024;
	ptr = (char*)malloc(size);
	if (ptr) {
		for (i=0;i<size;i+=PAGE_SIZE)
			ptr[i]=0;
		free(ptr);
	}
	return 0;
}
