/*-*-c++-*-
 * $Id: strset.h,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef STRSET_H
#define STRSET_H

#include <qstring.h>
#include "avl.h"

/**A set based on QStrings using an avl-tree.
  *@author Michael Geselbracht
  */

class StrSet : public Avl<QString> {
public: 
	StrSet();
	~StrSet();
	typedef AvlIterator<QString> Iterator;
	
	/** maximum number of entries in suggestion list.
	*/
	void setMaxSuggestions(unsigned int);
	
	/** return a list of suggestions for the given key.
	*/
	AvlList<QString>* getSuggestions(const QString& key);

private:
	StrSet(const StrSet&);
	void getSuggestions_priv(AvlNode<QString>* root, const QString& key);
	
	unsigned int oMaxSuggestions;
	unsigned int oCounter;
	AvlList<QString>* oList;
};

#endif
