/*-*-c++-*-
 * $Id: cwalkexpressiondialog.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CWALKEXPRESSIONDIALOG_H
#define CWALKEXPRESSIONDIALOG_H

#include <qdialog.h>

class QLabel;
class QComboBox;
class QPushButton;
class QStringList;
class QFrame;

/**
  *@author Michael Geselbracht
  */

class CWalkExpressionDialog : public QDialog {
   Q_OBJECT

public:
	CWalkExpressionDialog(QWidget* parent=0, const char* name=0);
	~CWalkExpressionDialog();
	
	QString type() const;
	QString member() const;
	QString address() const;
	
	// set focus to `Type'-field and exec()
	int fExec();
	
	// set default value for each field
	void setDefault(const QString& type, const QString& member, const QString& addr);
	
	// clear all entries
	void clear();
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	virtual bool eventFilter(QObject*, QEvent*);
	
protected slots:
	void slotOk();
	void slotCancel();
	
private:
	QLabel* oTypeL;
	QLabel* oMemberL;
	QLabel* oAddressL;
	QComboBox* oTypeC;
	QComboBox* oMemberC;
	QComboBox* oAddressC;
	QPushButton* oOk;
	QPushButton* oCancel;
	QFrame* oTopFrame;
	QFrame* oBotFrame;
};

#endif
