/*-*-c++-*-
 * $Id: ctaskbar.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "ctaskbar.h"
#include "ctaskbutton.h"

#define TASKBAR_HEIGHT 25

CTaskBar::CTaskBar(QWidget* parent, const char* name) : QFrame(parent, name)
{
	setFrameStyle(Panel | Sunken);
	setLineWidth(2);
	setMinimumSize(10, TASKBAR_HEIGHT);
	resize(10, TASKBAR_HEIGHT);
	
	oTaskList.setAutoDelete(true);
}

CTaskBar::~CTaskBar()
{
}

void
CTaskBar::resizeEvent(QResizeEvent*)
{
	layout();
}

void
CTaskBar::layout()
{
	int bw = 150; // initial button width
	const int bh = height() - 2*lineWidth();
	
	if (!oTaskList.count()) { // nothing to do
		return;
	}
	
	// enough space for all buttons with their default width ?
	if (oTaskList.count() * bw > (unsigned) width() - 2*lineWidth()) { // No.
		bw = (width() - 2*lineWidth()) / oTaskList.count();
	}
	
	int x = lineWidth();
	QWidget* walker = oTaskList.first();
	while (walker != 0) {
		walker->setGeometry(x, lineWidth(), bw, bh);
		x += bw;
		walker = oTaskList.next();
	}
}

void
CTaskBar::updateState()
{
	return;

	CTaskButton* walker = oTaskList.first();
	while (walker != 0) {
		if (!walker->widget()->isVisible()) {
			walker->setText("(" + walker->text() + ")");
		}
		else {
			walker->setText(walker->text());
		}
		walker = oTaskList.next();
	}
}

void
CTaskBar::addWidget(QWidget* win)
{	
	// check for duplicate captions
	int count = 1;
	CTaskButton* walker = oTaskList.first();
	QString clabel = win->caption();
	while (walker != 0) {
		QString wlabel = walker->text();
		if (!wlabel.isEmpty() && wlabel == clabel) {
			count = walker->number() + 1;
		}
		walker = oTaskList.next();
	}
	
	CTaskButton* tb = new CTaskButton(win, this);
	tb->show();
	
	tb->setNumber(count);
	
	oTaskList.append(tb);
	layout();
	cbActivated(win);
}

void
CTaskBar::removeWidget(QWidget* win)
{
	CTaskButton* walker = oTaskList.first();
	
	while (walker != 0) {
		if (walker->widget() == win) {
			oTaskList.remove();
			emit sigWidgetRemoved(win);
			layout();
			break;
		}
		
		walker = oTaskList.next();
	}
}

void
CTaskBar::cbActivated(QWidget* w)
{
	CTaskButton* walker = oTaskList.first();
	while (walker != 0) {
		if (walker->widget() == w) {
			walker->setOn(true);
		}
		else {
			walker->setOn(false);
		}
		
		walker = oTaskList.next();
	}
	
	updateState();
}
