/*-*-c++-*-
 * $Id: crashtypes.h,v 1.2 2002/04/19 15:24:17 felfert Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CRASHTYPES_H
#define CRASHTYPES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef WIN32
// On Windows, we use subdirs of the program folder
#define VERSION "1.0"
#define PREFIX "."
#define DATADIR PREFIX "/Data"
#define DOCDIR PREFIX "/Manual"
#define LCRASH_DEFAULT_PATH "N/A"
#else
#define DATADIR PREFIX "/share/qlcrash"
#define DOCDIR DATADIR "/Manual"
#define LCRASH_DEFAULT_PATH "/sbin/lcrash"
#endif

// define a standardized caption
#define stdCaption(s) (tr("QLcrash") + " - " + (s))

#define CMD_PROMPT ">> "
#define CMD_PROMPT_LEN 3

#undef QLDEBUG

#ifdef QLDEBUG
#include <iostream>
#define PRINT(x) x
#else
#define PRINT(x)
#endif

class CGraphObject;

// edges in graph manager
struct CLine {
	CGraphObject* obj;
	unsigned short x1;
	unsigned short y1;
	unsigned short x2;
	unsigned short y2;
};

#include <qstring.h>
#include <qlist.h>
#include <qvector.h>

typedef QList<QVector<QString> > TaskListType;
enum NodeType { Null=0, Struct, Scalar, Array, ArrayStruct, Pointer };

namespace qlc {
	enum { Undef=0, Scalar, Struct, Array };
	enum DumpType { Hex=0, Decimal=1, Octal=2 };
	enum DumpFormat { Word=0, DoubleWord=1, HalfWord=2, Byte=3 };
}

#endif
