/*-*-c++-*-
 * $Id: cchildmanager.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef _NEW_CCHILDMANAGER_H_
#define _NEW_CCHILDMANAGER_H_

class QDialog;
class QPushButton;
class QListBox;
class QListBoxItem;
class QLcrashDoc;

#include <qobject.h>
#include <qpixmap.h>

#include "crashtypes.h"
#include "cchildmanagerbase.h"

class CChildManager : public QObject, public CChildManagerBase {
	Q_OBJECT

public:
	CChildManager(QObject* parent=0);
	~CChildManager();

	bool valid();
	void setArgs(const QStringList&);
	void forkChild();
	void killChild(int sig=0);
	void setSignalOnTimeout(int signal);
	bool command(QString cmd, QString& result, int maxCycle=200);
	bool writeStdin(QString);
	void processEvents(int);
	inline int retval() const {return oRetval;}

signals:
	void sigChildDied();
	void sigChildStarted();
	void sigBusy(bool);
	void sigStdout(QString);
	void sigStderr(QString);

public slots:
	void slotSetup();

private slots:
	void slotShowAbout();
	void slotRefresh();
	void slotItemClicked(QListBoxItem *);
	void slotConfigure();
	void slotBusy();
	void slotActivate();

	void slotStdout(QString);
	void slotStderr(QString);
	void slotChildStarted();
	void slotChildDied();

private:
	void enableButtons(bool);
	void checkPlugins();

	QDialog     *setupDialog;
	QListBox    *pluginListBox;
	QPushButton *refreshButton;
	QPushButton *aboutButton;
	QPushButton *activateButton;
	QPushButton *configButton;
	QPushButton *cancelButton;
	QPushButton *okButton;

	QPixmap     uPixmap;
	QPixmap     cPixmap;
	QPixmap     aPixmap;

	TPluginList  plist;
	CChildPlugin *activePlugin;
	QLcrashDoc   *doc;

	bool gotStderr;
	bool childDied;
	bool pluginsChecked;
	int oRetval;

	QString *collectStdout;
	QString *collectStderr;
};

#endif
/*
 * Local variables:
 * c-basic-offset: 8
 * End:
 */

