/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */

/*
 * This file includes wrapper functions because the header files
 * between kernel and user space have tons of conflicts.  Hopefully
 * this won't be necessary someday.
 */
#ifdef __KERNEL__
#undef __KERNEL__
#endif
#include <sys/stat.h>
#include <unistd.h>

/*
 * check_type_dir() -- run the stat() operation without having all the
 *                     inline definitions conflicted by the kernel.  Make
 *                     sure <path> is a directory.
 */
int
check_type_dir(char *path)
{
	struct stat sbuf;

	if (stat(path, &sbuf) < 0) {
		return (-1);
	}

	return (S_ISDIR(sbuf.st_mode) ? 1 : 0);
}

/*
 * check_type_dev() -- run the stat() operation without having all the
 *                     inline definitions conflicted by the kernel.  Make
 *                     sure <path> is a block device type.
 */
int
check_type_dev(char *path)
{
	struct stat sbuf;

	if (stat(path, &sbuf) < 0) {
		return (-1);
	}

	return (S_ISBLK(sbuf.st_mode) ? 1 : 0);
}
