/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#include <lcrash.h>

/*
 * history_usage() -- Print the usage string for the 'history' command.
 */

#define _HIST_USAGE "[n]"
void
history_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _HIST_USAGE);
}

/*
 * history_help() -- Print the help information for the 'history' command.
 */
void
history_help(command_t *cmd)
{
	CMD_HELP(cmd,_HIST_USAGE,
		"Without the optional parameter, displays the current history. "
		"Optional argument 'n' specifies the number of commands that "
		"are kept in the history list.");
}

/*
 * history_complete() -- Complete arguments of 'history' command.
 */
char *
history_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	history_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
