/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2004
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 ************************************************************/

#ifndef _LKST_EVENTDESC_H_
#define _LKST_EVENTDESC_H_

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/lkst.h>

/*event-type description flag*/
#define LKST_EDF_LOADED 0x10000
#define LKST_EDF_MASKABLE LKST_EF_MASKABLE
#define LKST_EDF_MULTIPLE LKST_EF_MULTIPLE

#define LKST_EDF_NORMAL LKST_EFG_NORMAL
#define LKST_EDF_INLINE LKST_EFG_INLINE
#define LKST_EDF_UNDEF  LKST_EFG_UNDEF
#define LKST_EDF_MODULE LKST_EFG_MODULE

struct lkst_etype_description {
	char * mnemonic;
	char * name;
	char * args[4];
	int flags;
};
extern struct lkst_etype_description lkst_etype_desc[];
int lkst_etype_desc_load(char * fname);
void lkst_etype_desc_free_all(void);

#endif
