package org.xpnd.component.renderer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

import org.gamelet.middleware.canvas.BaseCanvas;
import org.gamelet.middleware.canvas.renderer.AbstractRenderer;
import org.gamelet.middleware.midlet.Gamelet;
import org.gamelet.middleware.util.FPSCounter;
import org.lixm.core.common.LIXMException;
import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLType;
import org.lixm.core.list.AttributesList;
import org.lixm.core.list.XMLCursor;
import org.lixm.core.list.XMLModelList;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.AttributeModel;
import org.lixm.core.model.CharactersModel;
import org.lixm.core.model.ElementModel;
import org.lixm.core.model.EndDocumentModel;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.StartDocumentModel;
import org.lixm.core.model.StartTagModel;
import org.lixm.optional.v10.atattch.XMLDispatcher;
import org.lixm.optional.v10.atattch.XMLReceiver;
import org.lixm.optional.v11.framework.rpf.pipeline.castom.CastomPipeLine;
import org.lixm.optional.v11.namespace.NamespaceBinding;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xpnd.component.action.ActionMap;
import org.xpnd.component.action.ElementAction;
import org.xpnd.component.action.impl.CWElementAction;
import org.xpnd.component.action.impl.LBElementAction;
import org.xpnd.component.action.impl.PBElementAction;
import org.xpnd.component.action.impl.PElementAction;
import org.xpnd.component.action.impl.BackgroundElementAction;
import org.xpnd.component.action.impl.ForeGroundElementAction;
import org.xpnd.component.action.impl.SleepElementAction;
import org.xpnd.component.action.impl.SoundElementAction;
import org.xpnd.component.action.impl.actions.ContorolElementActions;
import org.xpnd.component.action.impl.actions.METAElementActions;
import org.xpnd.impl.modelizer.xpp.NamespaceBindingImpl;
import org.xpnd.impl.modelizer.xpp.XMLModelListCache;
import org.xpnd.impl.modelizer.xpp.XMLModelizerImpl;

/**
 * _uot@LoXɃubg@\B
 * TODO bZ[Wt[ƂȂXvCg֕`悷悤ɕύX\
 * @author tasogare
 *
 */
public class HeilevelRenderer extends AbstractRenderer implements XMLReceiver, XMLDispatcher{

    public class HeilevelRendererHandler extends DefaultHandler {

	private NamespaceBinding namespaces;
	private XMLModelList list;

	private Hashtable labelTable;
	private int count;

	public HeilevelRendererHandler(XMLModelList list, NamespaceBinding namespaces) {
	    this.namespaces = namespaces;
	    this.list = list;
	    labelTable = new Hashtable();
	}

	public void startDocument() throws SAXException {
	    list.add(new StartDocumentModel(null));
	    count++;
	}

	public void endDocument() throws SAXException {
	    list.add(new EndDocumentModel(null));
	    count++;
	}

	public void characters(char[] ch, int start, int length)
		throws SAXException {
	    list.add(new CharactersModel(new String(ch, start, length)));
	    count++;
	}

	public void startElement(String uri, String localName, String qName,
		Attributes attributes) throws SAXException {

	    ActionMap map1 = (ActionMap)namespaces.getPrefix(uri);
	    String elemPrefix = map1.getPrefix();

	    AttributesList attList = new AttributesList(attributes.getLength());
	    for (int i = 0; i < attributes.getLength(); i++) {

		    ActionMap map2 = (ActionMap)namespaces.getPrefix(uri);
		    String pref = map2.getPrefix();
		attList.add(new AttributeModel(attributes.getLocalName(i),
			attributes.getValue(i), pref, attributes.getURI(i)));
	    }

	    StartTagModel startTag = new StartTagModel(
		    new ElementModel(localName, elemPrefix, uri),
		    attList);
	    list.add(startTag);
	    count++;

	    if(startTag.getElement().getPefix().equals("novel") &&
		    startTag.getElement().getName().equals("label")){
		labelTable.put(startTag.getAttributes().getName("id").getValue(), new Integer(count));
	    }
	}

	public void endElement(String uri, String localName, String qName)
		throws SAXException {

	    ActionMap map = (ActionMap)namespaces.getPrefix(uri);
	    String elemPrefix = map.getPrefix();
	    list.add(new EndTagModel(new ElementModel(
		    localName, elemPrefix, uri)));
	    count++;
	}

	public void startPrefixMapping(String prefix, String uri)
		throws SAXException {

		ActionMap map = new ActionMap((prefix == null) ? "" : prefix);
		namespaces.put(map, uri);
	}

	public void endPrefixMapping(String prefix) throws SAXException {
	}

	/**
	 * OԃoCfBOԂ
	 * @return OԃoCfBO
	 */
	public NamespaceBinding getNamespaceBinding(){
	    return namespaces;
	}

	public Hashtable getLabelTable(){
	    return labelTable;
	}
    }

    private Gamelet owner;

    private CastomPipeLine pipeLine;

    //߂Ă̕`悩H
    private boolean isFirst;

    //ItXN[NA邩H
    private boolean isClearOffscreen=true;

    /*
     * `֘A
     */

    //XN[TCY
    private int screenWidh = 320;
    private int screenHeight = 240;

    //bZ[Wt[̈ʒuAE
    private int frameX;
    private int frameY;
    private int frameWidh;
    private int frameHeight;

    //`摬x萔

    public static final int DRAW_CHAR_SPEED_A = 0;
    public static final int DRAW_CHAR_SPEED_B = 200;
    public static final int DRAW_CHAR_SPEED_C = 400;

    //݂̕`摬x
    private int currDrawCharSpeed = DRAW_CHAR_SPEED_A;

    //݂̍s
    private int currLineCount = -1;

    //݂̗
    private int currColumnCount = 0;

    //ős
    private int maxLineCount;

    //ő
    private int maxColumnCount;

    /*
     * ItXN[
     */

    // _uobt@̃TCY
    private int widh;
    private int height;

    // ItXN[TCY
    private int offbuffWidh;
    private int offbuffHeight;

    // _uobt@痘płItXN[̈ʒu
    private int buffOffsetX;
    private int buffOffsetY;

    // _uobt@ɒH
    // falsȅꍇ͐ɒ
    private boolean horizontal;

    private int clipX;
    private int clipY;

    //wi摜
    private Image bg;

    //gvobt@
    private Image tripleBuff;
    public Graphics tripleGraphics;

    //C֘A
    public final LayerManager layerManager = new LayerManager();

    /*
     * wiP + bZ[Wt[ { OiR
     */

    private Image messFrameImage;

    public Sprite backgroundSprite;
    public Sprite messFrameSprite;
    public final Sprite[] sprites = new Sprite[3];
    public final String[] spriteNames = new String[3];

    public HeilevelRendererHandler handler;
    private XMLModelizerImpl modelizer;
    public XMLModelList models;
    public Hashtable labelTable;
    public XMLCursor cursor;

    /*
     *xml̃LbV֘A 
     */
    private Hashtable xmlCache;

    //ANV}bsO
    private NamespaceBindingImpl modelActions;

    //ɏׂf
    private AbstractModel nextModel;

    //񂵂ɂꂽf̃X^bN
    private Stack pendings;

//    Graphics g;

    private int keyState;

    //NbN҂
    public static final String STATE_CLICK_WAIT = "st_cw";

    public HeilevelRenderer(BaseCanvas canvas) {
	super(canvas);
	init();
    }

    public HeilevelRenderer(BaseCanvas canvas, FPSCounter counter) {
	super(canvas, counter);
	init();
    }

    /**
     * vpeB
     */
    public void propertyAnalyze() {

	/*
	 * XN[擾
	 */
	screenWidh = Integer.parseInt(getOwner().getAppProperty("screen-widh"));
	screenHeight = Integer.parseInt(getOwner().getAppProperty("screen-height"));

	/*
	 * t[擾
	 */

	frameX = Integer.parseInt(getOwner().getAppProperty("frame-x"));
	frameY = Integer.parseInt(getOwner().getAppProperty("frame-y"));
	frameWidh = Integer.parseInt(getOwner().getAppProperty("frame-widh"));
	frameHeight = Integer.parseInt(getOwner().getAppProperty("frame-height"));

	System.out.println("frame x " + frameX);
	System.out.println("frame y " + frameY);
	System.out.println("frame widh " + frameWidh);
	System.out.println("frame height " + frameHeight);

	InputStream is = getClass().getResourceAsStream(getOwner().getAppProperty("message-frame"));

	try {
	    messFrameImage = Image.createImage(is);
	    messFrameSprite = new Sprite(messFrameImage);
	} catch (IOException e) {
	    e.printStackTrace();
	    getOwner().shutdown(true);
	}
	layerManager.insert(messFrameSprite, 0);
	messFrameSprite.setVisible(true);
	/*
	 * t[擾I
	 */
    }
    
    public void setOwner(Gamelet owner) {
	this.owner = owner;
    }

    public Gamelet getOwner() {
	return owner;
    }

    public void init() {

	xmlCache = new Hashtable(10);
	models = new XMLModelList(10);
	modelActions = new NamespaceBindingImpl();

	try {
	    handler = new HeilevelRendererHandler(models, modelActions);
	    modelizer = new XMLModelizerImpl(models, handler);
	    modelizer.modelize("/start.xml");
	} catch (LIXMPhaseException e) {
	    System.err.println(e);
	    getOwner().shutdown(false);
	}

	initActionMap();

	models = modelizer.getList();
	cursor = models.getCursor();
	labelTable = this.handler.labelTable;

	pipeLine = new CastomPipeLine(models, (XMLReceiver)this, (XMLDispatcher)this);

    }

    private void initActionMap() {
	ActionMap novelAction = (ActionMap)modelActions.getPrefix("http://www.ayane.org/novel");

	novelAction.getActions().put("p", new PElementAction(this));
	novelAction.getActions().put("setbg", new BackgroundElementAction(this));
	novelAction.getActions().put("setfg",  new ForeGroundElementAction(this));
	novelAction.getActions().put("sound", new SoundElementAction(this));
	novelAction.getActions().put("sleep", new SleepElementAction(this));

	ContorolElementActions contorolActions = new ContorolElementActions(this);
	novelAction.getActions().put("jump", contorolActions.getAction("jump"));
	novelAction.getActions().put("return", contorolActions.getAction("return"));
	novelAction.getActions().put("lb", new LBElementAction(this));
	novelAction.getActions().put("pb", new PBElementAction(this));
	novelAction.getActions().put("cw", new CWElementAction(this));
	
	METAElementActions metaActions = new METAElementActions(this);
	novelAction.getActions().put("meta", metaActions.getAction("meta"));
	novelAction.getActions().put("cache", metaActions.getAction("cache"));

	
    }

    /**
     * gvobt@̐
     * @param widh
     * @param height
     */
    protected void createTripleBuffer(int widh,  int height){
	tripleBuff = Image.createImage(widh, height);
	tripleGraphics = tripleBuff.getGraphics();
    }

    protected void beforeMainRender(Graphics g) {

	System.out.println("main render before process!");

	int keyStates = this.canvas.getKeyStates();
	if(getState().equals(HeilevelRenderer.STATE_CLICK_WAIT)){
	    if((keyStates & this.canvas.FIRE_PRESSED) !=0){
		setState(HeilevelRenderer.STATE_RUNNING);
	    }
	}

	if(!getState().equals(HeilevelRenderer.STATE_CLICK_WAIT)){

	    g.setFont(getCurrentFont());
	    g.setColor(fgColor);

	    if (getGraphics() == null) {

		clipX = g.getClipX();
		clipY = g.getClipY();

		if (Math.max(g.getClipWidth(), g.getClipHeight()) == g.getClipWidth()) {

		    widh = g.getClipWidth() * 2;
		    height = g.getClipHeight();
		    offbuffWidh = widh - g.getClipWidth();
		    offbuffHeight = height;

		    horizontal = true;
		} else {

		    widh = g.getClipWidth();
		    height = g.getClipHeight() * 2;
		    offbuffWidh = widh;
		    offbuffHeight = height - g.getClipHeight();

		    horizontal = false;
		}

		buffOffsetX = (horizontal) ? g.getClipWidth() : 0;
		buffOffsetY = (horizontal) ? 0 : g.getClipHeight();

		System.out.println("widh : " + widh);
		System.out.println("height : " + height);
		System.out.println("off widh : " + offbuffWidh);
		System.out.println("off height : " + offbuffHeight);

		getGraphics(widh, height);
	    }
	}
    }

    protected void afterMainRender(Graphics g) {

	System.out.println("main render after process!");
    }

    protected void mainRender(Graphics g) {

	System.out.println("main drawing");

	
	/*
	 * ItXN[NAtOĂƂ̂݃ItXN[NAwi`悷B
	 * ItXN[NAtO͕`撆t[͂ݏoƂ
	 * pvf̏I^OƂɃtOB
	 */
	if(isClearOffscreen){
	    clearOffscreen(getGraphics());
	    renderBackground(getGraphics(), 0, 0, widh, height);
	    int layX = horizontal ? screenWidh : screenHeight;
	    System.out.println("layer localation : " + layX);
	    System.out.println("horizontal : " + horizontal);
	    layerManager.paint(getGraphics(), layX, 0);
	}

	this.tripleGraphics=g;

	if(!getState().equals(HeilevelRenderer.STATE_CLICK_WAIT)){
	    try {
		pipeLine.shed();
	    } catch (LIXMException e) {
		e.printStackTrace();
	    }
	}

	blitOffScreen();
	flushCanvas(g);

    }

    /**
     * LoXtbV
     * @param g _uobt@
     */
    public void flushCanvas(Graphics g) {
	g.drawImage(getBGI(), 0, 0, Graphics.LEFT | Graphics.TOP);
	canvas.flushGraphics();
    }

    /**
     * ItXN[blit
     */
    public void blitOffScreen() {
	getGraphics().copyArea(getOffScreenOffsetX(), getOffScreenOffsetY(),
		getOffScreenWidh(), getOffScreenHeight(), 0, 0, Graphics.LEFT | Graphics.TOP);
    }

    /**
     * ItXN[
     * @param g _uobt@
     */
    public void clearOffscreen(Graphics g) {
	g.setColor(0xffffff);
	g.fillRect(buffOffsetX, buffOffsetY, offbuffWidh, offbuffHeight);
    }

    /**
     * gvobt@NA
     */
//    public void clearTripleBuffer() {
//	tripleGraphics.setColor(0xffffff);
//	tripleGraphics.fillRect(0, 0, tripleBuff.getWidth(), tripleBuff.getHeight());
//    }

    /**
     * gvobt@_uobt@ɓ]B
     */
//    public void transfarTripleBuffer(){
//	/*getGraphics()*/offbuff.drawImage(tripleBuff, buffOffsetX, buffOffsetY, Graphics.LEFT | Graphics.TOP);
//    }

    /**
     * _uobt@̃ItXN[̃ItZbgXԂ
     * @return ItZbgX
     */
    public int getOffScreenOffsetX() {
	return buffOffsetX;
    }

    /**
     * _uobt@̃ItXN[̃ItZbgYԂ
     * @return ItZbgY
     */
    public int getOffScreenOffsetY() {
	return buffOffsetY;
    }

    /**
     * ItXN[̕Ԃ
     * 
     * @return ItXN[̕
     */
    public int getOffScreenWidh() {
	return offbuffWidh;
    }

    /**
     * ItXN[̍Ԃ
     * 
     * @return ItXN[̍
     */
    public int getOffScreenHeight() {
	return offbuffHeight;
    }

    public void run() {

	canvas.renderCanvas(screenWidh, screenHeight);
    }

    public void receive(AbstractModel model) throws LIXMException {

	if(model ==null) return;

	switch (model.getXMLType()) {
	case XMLType.CHARACTERS:

	    CharactersModel chars = (CharactersModel)model;
	    System.out.println(chars);
	    handleCharactersModel(chars);
	    break;

	case XMLType.START_TAG:

	    StartTagModel startTag = (StartTagModel)model;
	    System.out.println(startTag);
	    handleStartTagModel(startTag);
	    break;

	case XMLType.END_TAG:

	    EndTagModel endTag = (EndTagModel)model;
	    System.out.println(endTag);
	    handleEndTagModel(endTag);
	    break;

	case XMLType.START_DOCUMENT:


	    break;

	case XMLType.END_DOCUMENT:

	    getOwner().shutdown(false);

	    break;

	default:
	    throw new LIXMException("\ʃfo܂B");
	}

    }

    public void dispath(XMLReceiver receiver) throws LIXMException {

	AbstractModel model = null;
	if (models.size() > cursor.next()) {
	    model = models.get(cursor.inc());
	}

	System.out.println(model);
	receiver.receive(model);
    }

    /*
     * fnhQ
     */

    protected void handleCharactersModel(CharactersModel chars){
	if(chars.getText().trim().equals("")) return;

	isClearOffscreen=false;

	int fntWitgh = this.getCurrentFont().charWidth('');
	int fntHeight = this.getCurrentFont().getHeight();

	System.out.println("font :" + fntWitgh + " * " + fntHeight);
	this.maxLineCount = frameWidh / fntWitgh;
	this.maxColumnCount = frameHeight / fntHeight;
	System.out.println(maxLineCount + " * " + maxColumnCount);


	for(int i=0;  i < chars.getText().trim().length(); i++){

	    currLineCount++;

	    char drawChar = chars.getText().trim().toCharArray()[i];
	    this.drawChar(getGraphics(), drawChar,
		clipX + getOffScreenOffsetX() + frameX + currLineCount * fntWitgh,
		clipY + frameY + currColumnCount * fntHeight,
		Graphics.LEFT | Graphics.TOP);

	    blitOffScreen();
	    flushCanvas(this.tripleGraphics);

	    try {
		Thread.currentThread().sleep(currDrawCharSpeed);
	    } catch (InterruptedException e) {
		e.printStackTrace();
	    }

	    //s
	    if(currLineCount == maxLineCount){
		processLineBreak();
		continue;
	    }

	    //y[W蔻
	    if(currColumnCount == maxColumnCount){
		processPageBreak();
		continue;
	    }
	}
    }

    /**
     * y[W
     */
    public void processPageBreak() {
	currLineCount = -1;
	currColumnCount=0;

	clearOffscreen(getGraphics());
	renderBackground(getGraphics(), 0, 0, widh, height);
	int layX = horizontal ? screenWidh : screenHeight;
	layerManager.paint(getGraphics(), layX, 0);
    }

    /**
     * s
     */
    public void processLineBreak() {
	currLineCount = -1;
	currColumnCount++;
    }

    /**
     * NbN҂
     */
    public void processClickWait(){
	setState(HeilevelRenderer.STATE_CLICK_WAIT);
    }

    /**
     * xml̃LbV
     * @param name LbVxmlt@C
     */
    public void processCache(String name){
	XMLModelList list = new XMLModelList(10);
	HeilevelRendererHandler handler = 
	    new HeilevelRendererHandler(list, modelActions);
	XMLModelizerImpl modelizer=null;
	try {
	    modelizer = new XMLModelizerImpl(list, handler);
	} catch (LIXMPhaseException e) {
	    e.printStackTrace();
	    getOwner().shutdown(true);
	}
	try {
	    modelizer.modelize(name);
	} catch (LIXMPhaseException e) {
	    e.printStackTrace();
	    getOwner().shutdown(true);
	}
	xmlCache.put(name, new XMLModelListCache(list, handler.getLabelTable()));
	initActionMap();
    }

    protected void handleStartTagModel(StartTagModel startTag) throws LIXMException{
	ActionMap map = (ActionMap)modelActions.getPrefix(startTag.getElement().getNamespace());
	if(map==null) return;

	ElementAction action = (ElementAction)map.getActions().get(startTag.getElement().getName());
	if(action==null) return;

	action.actionStartTag(startTag);
    }

    protected void handleEndTagModel(EndTagModel endTag) throws LIXMException{
	ActionMap map = (ActionMap)modelActions.getPrefix(endTag.getElement().getNamespace());
	if(map==null) return;

	ElementAction action = (ElementAction)map.getActions().get(endTag.getElement().getName());
	if(action==null) return;

	action.actionEndTag(endTag);
    }

    public void setState(String state) throws IllegalStateException{

	    if(STATE_STABLE.equals(state)){

		this.state = state;
		System.out.println(" crrent state : " + state);

		if(getRendererStateListener() != null){
		    getRendererStateListener().changeStable();
		}

	    }else if(STATE_RUNNING.equals(state)){

		this.state = state;
		System.out.println(" crrent state : " + state);

		if(getRendererStateListener() != null){
		    getRendererStateListener().changeRunning();
		}

	    }else if(STATE_SUSPEND.equals(state)){

		this.state = state;
		System.out.println(" crrent state : " + state);

		if(getRendererStateListener() != null){
		    getRendererStateListener().changeSuspend();
		}

	    }else if(STATE_CLICK_WAIT.equals(state)){
		this.state = state;
		System.out.println(" crrent state : " + state);

		if(getRendererStateListener() != null){
		    getRendererStateListener().changeSuspend();
		}
	    }
	}

    public Hashtable getXmlCache() {
        return xmlCache;
    }

    public BaseCanvas getCanvas(){
	return this.canvas;
    }

    public int getCurrDrawCharSpeed() {
        return currDrawCharSpeed;
    }

    public void setCurrDrawCharSpeed(int currDrawCharSpeed) {
        this.currDrawCharSpeed = currDrawCharSpeed;
    }

    public boolean isHorizontal() {
        return horizontal;
    }

    public int getScreenWidh() {
        return screenWidh;
    }

    public int getScreenHeight() {
        return screenHeight;
    }
}
