package org.xpnd.component.action.impl;

import java.io.IOException;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

import org.lixm.core.common.LIXMException;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.StartTagModel;
import org.xpnd.component.action.ElementAction;
import org.xpnd.component.renderer.HeilevelRenderer;
/**
 * vf
 * src
 * x
 * y
 * remove
 * @author tasogare
 *
 */
public class BackgroundElementAction implements ElementAction {
    private HeilevelRenderer renderer;

    public BackgroundElementAction(HeilevelRenderer renderer){
	this.renderer = renderer;
    }

    public int actionEndTag(EndTagModel endTag) throws LIXMException {
	return 0;
    }

    public int actionStartTag(StartTagModel startTag) throws LIXMException {

	
	if(startTag.getAttributes().getName("remove") != null){
	    renderer.layerManager.remove(renderer.backgroundSprite);
	    return 0;
	}

	String bgSRC = startTag.getAttributes().getName("src").getValue();
	try {
	    renderer.backgroundSprite = new Sprite(Image.createImage(bgSRC));
	} catch (IOException e) {
	    e.printStackTrace();
	    System.err.println("摜F" + bgSRC + "܂");
	    renderer.getOwner().shutdown(true);
	}

	renderer.layerManager.insert(renderer.backgroundSprite, 0);

	int x = Integer.parseInt(startTag.getAttributes().getName("x").getValue());
	int y = Integer.parseInt(startTag.getAttributes().getName("y").getValue());
	Sprite bg = (Sprite)renderer.layerManager.getLayerAt(0);
	bg.move(x, y);

	return 0;
    }

}
