package org.xpnd.app;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

import org.gamelet.middleware.canvas.BaseCanvas;
import org.gamelet.middleware.midlet.Gamelet;
import org.gamelet.middleware.util.FPSCounter;
import org.xpnd.component.MainCanvas;
import org.xpnd.component.renderer.HeilevelRenderer;

public class Ayane extends Gamelet  implements CommandListener {

    /*
     *R}hQ 
     */
    private Command cmdExit = null;
    private Command cmdAbout = null;

    /*
     * CLoX
     */
    private BaseCanvas mainCanvas = null;

    /*
     * _
     */
    private HeilevelRenderer renderer = null;

    public Ayane() {
	super();
	initAll();
    }

    /**
     * vpeB
     */
    public void propertyAnalyze() {
	renderer.propertyAnalyze();
    }

    protected void initAll() {
	initCanvas();
	initCommand();

	propertyAnalyze();
	Display.getDisplay(this).setCurrent(mainCanvas);
    }

    protected void initCanvas() {
	try {
	    mainCanvas = new MainCanvas(true);
	} catch (Exception e) {
	    e.printStackTrace();
	}
	renderer = new HeilevelRenderer(mainCanvas, new FPSCounter(60));
	renderer.setOwner(this);
	renderer.init();


	mainCanvas.setAnimator(renderer);
    }

    protected void initCommand() {
	cmdExit = new Command("buy", Command.EXIT, 1);
	cmdAbout = new Command("about", Command.HELP, 0);

	mainCanvas.addCommand(cmdExit);
	mainCanvas.addCommand(cmdAbout);
	mainCanvas.setCommandListener(this);
    }

    public void commandAction(Command cmd, Displayable disp) {
	if(cmd == cmdExit){
	    shutdown(false);
	}else if(cmd == cmdAbout){

	    /*
	     * ̒쌠\폜Ă͂ȂȂB
	     * ܂쌠\\Ȃ悤ɉςĂ͂ȂȂB
	     */
	    String about =	"This game based Ayane Framework, It is licensed by the BSD license.\n" +
	    				"This Framework used by MXP1.\n" +
	    				"Ayane Framework, Copyright 2008 tasogare. All rights reserved.\n" +
	    				"MXP1, Copyright (c) 2002 Extreme! Lab, Indiana University. All rights reserved.";
	    Alert aboutAlert = new Alert("Ayane Framework Copyright Info.");
	    aboutAlert.setType(AlertType.INFO);
	    aboutAlert.setString(about);
	    aboutAlert.setTimeout(Alert.FOREVER);

	    Display.getDisplay(this).setCurrent(aboutAlert, mainCanvas);
	}
    }

}
