package org.gamelet.middleware.util;

/**
 * FPSを制御します。
 * @author tasogare
 *
 */
public class FPSCounter {
	
	private long fps;
	private long now;
	private long frames;

	/**
	 * 任意のFPS値をカウントするFPSカウンタを作成します。
	 * @param fps
	 */
	public FPSCounter(long fps){
		this.fps = fps;
	}

	/**
	 * <p>カウンタを更新します。</p>
	 * @return 現在時刻
	 */
	public final long update(){
		frames++;
		return now = System.currentTimeMillis( );
	}

	/**
	 * <p>前回の更新から経過時間を計算し最適な休止時間を返します。</p>
	 * @return 最適な休止時間
	 */
	public final long elapsed(){
		long newTime = System.currentTimeMillis( ) - now;
		if( newTime < fps ){
			return newTime;
		}else{
			return 0;
		}
	}

    /**
     * <p>指定されたFPSを返します。</p>
     * @return FPS値
     */
    public final long getFPS() {
    	return fps;
    }

    /**
     * <p>現在のFPSを返します。</p>
     * @return 現在のFPS値
     */
    public final long getNowFPS(){
		return fps - ( System.currentTimeMillis( ) - now );
    }
}
