/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.manager;

import java.io.IOException;
import net.sourceforge.livepinger.manager.ConfigurationFile;
import net.sourceforge.livepinger.manager.ConfigureFrame;
import net.sourceforge.livepinger.manager.ValidationException;

public class Configuration {
    static Configuration instance;
    int popupLifeTime = 5;

    private Configuration() {
    }

    public static synchronized Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
            try {
                ConfigurationFile.load(instance);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return instance;
    }

    public synchronized int getPopupLifeTime() {
        return this.popupLifeTime;
    }

    public synchronized void setPopupLifeTime(int popupLifeTime) {
        this.popupLifeTime = popupLifeTime;
    }

    public synchronized void applyFrame(ConfigureFrame frame) throws ValidationException {
        String popupLifeTimeText = frame.getPopupLifeTimeTextField().getText();
        try {
            int popupLifeTime = Integer.parseInt(popupLifeTimeText);
            if (popupLifeTime <= 0) {
                throw new ValidationException("\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u8868\u793a\u6642\u9593\u306f1\u4ee5\u4e0a\u306e\u6574\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
            this.popupLifeTime = popupLifeTime;
        }
        catch (NumberFormatException e) {
            throw new ValidationException("\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u8868\u793a\u6642\u9593\u306f1\u4ee5\u4e0a\u306e\u6574\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
    }
}

