/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.extracter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.livepinger.crawler.OnCrawlDoneListener;
import net.sourceforge.livepinger.crawler.RequestRunner;
import net.sourceforge.livepinger.crawler.RequestRunnerQueue;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.dto.UstreamLive;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UstreamExtracter
extends ExtracterBase
implements RequestRunner.OnRequestDoneListener {
    private static Log log = LogFactory.getLog(UstreamExtracter.class);
    List<Live> activeLives = new ArrayList<Live>();
    static Pattern OFFLINE_PATTERN = Pattern.compile("\u73fe\u5728\u3001\u756a\u7d44\u306f\u30aa\u30d5\u30e9\u30a4\u30f3\u3067\u3059");
    static Pattern LIVENAME_PATTERN = Pattern.compile("<h2>[^<]+?<a href=\"/channel/[^\"]+?\">([^<]+?)</a>[^<]+?</h2>");

    @Override
    public List<Live> extract(String crawlUrl, String data) {
        ArrayList<Live> lives = new ArrayList<Live>();
        Matcher offlinePattern = OFFLINE_PATTERN.matcher(data);
        if (offlinePattern.find()) {
            return lives;
        }
        Matcher livenameMatcher = LIVENAME_PATTERN.matcher(data);
        if (livenameMatcher.find()) {
            UstreamLive live = new UstreamLive(crawlUrl, UstreamLive.getIdentifierFromUrl(crawlUrl), livenameMatcher.group(1));
            lives.add(live);
        }
        return lives;
    }

    @Override
    public String getCrawlUrl() {
        return null;
    }

    @Override
    public Class getLiveClass() {
        return UstreamLive.class;
    }

    @Override
    public void crawl(List<Live> targetLives, OnCrawlDoneListener crawlDoneListener) {
        List<Live> matchLives = this.collectMatchLives(targetLives);
        if (matchLives.isEmpty()) {
            if (crawlDoneListener != null) {
                crawlDoneListener.onCrawlDone(this, new ArrayList<Live>());
            }
            return;
        }
        this.activeLives = new ArrayList<Live>();
        RequestRunnerQueue runnerQueue = new RequestRunnerQueue(20);
        for (Live matchLive : matchLives) {
            log.info("[ustream crawl] url: " + matchLive.getUrl());
            RequestRunner runner = new RequestRunner(matchLive.getUrl(), this);
            runnerQueue.schedule(runner);
        }
        runnerQueue.waitAll();
        if (crawlDoneListener != null) {
            crawlDoneListener.onCrawlDone(this, this.activeLives);
        }
    }

    @Override
    public void onRequestDone(RequestRunner runner, String data) {
        this.activeLives.addAll(this.extract(runner.getUrl(), data));
    }
}

