/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.extracter;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.livepinger.dto.CavetubeLive;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CavetubeExtracter
extends ExtracterBase {
    private static Log log = LogFactory.getLog(CavetubeExtracter.class);
    static String CRAWL_URL = "http://gae.cavelis.net/index_live.xml";

    @Override
    public List<Live> extract(String data) {
        ArrayList<Live> lives = new ArrayList<Live>();
        try {
            SAXReader reader = new SAXReader(false);
            Document document = reader.read(new ByteArrayInputStream(data.getBytes("UTF-8")));
            List entries = document.getRootElement().elements("entry");
            for (Element entry : entries) {
                Element url = entry.element("id");
                Element title = entry.element("title");
                Element name = entry.element("author").element("name");
                CavetubeLive live = new CavetubeLive(url.getText(), name.getText(), title.getText());
                live.setOnair(true);
                lives.add(live);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return lives;
    }

    @Override
    public String getCrawlUrl() {
        return CRAWL_URL;
    }

    @Override
    public Class getLiveClass() {
        return CavetubeLive.class;
    }
}

