/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.crawler;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.livepinger.crawler.RequestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestRunnerQueue {
    private static Log log = LogFactory.getLog(RequestRunnerQueue.class);
    List<RequestRunner> requestRunners;
    int size;

    public RequestRunnerQueue(int size) {
        this.size = size;
        this.requestRunners = new CopyOnWriteArrayList<RequestRunner>();
    }

    public void schedule(RequestRunner runner) {
        while (true) {
            if (this.requestRunners.size() < this.size) break;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        runner.setOnRequestDoneListener(new OnRequestDoneCatcher(runner.getOnRequestDoneListener()));
        this.requestRunners.add(runner);
        runner.start();
    }

    public void waitAll() {
        while (this.requestRunners.size() != 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class OnRequestDoneCatcher
    implements RequestRunner.OnRequestDoneListener {
        RequestRunner.OnRequestDoneListener originalListener;

        public OnRequestDoneCatcher(RequestRunner.OnRequestDoneListener originalListener) {
            this.originalListener = originalListener;
        }

        @Override
        public void onRequestDone(RequestRunner runner, String data) {
            if (this.originalListener != null) {
                this.originalListener.onRequestDone(runner, data);
            }
            RequestRunnerQueue.this.requestRunners.remove(runner);
        }
    }
}

