/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.livepinger.crawler;

import java.util.Calendar;
import java.util.List;
import net.sourceforge.livepinger.crawler.OnCrawlDoneListener;
import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.extracter.ExtracterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Crawler
extends Thread
implements OnCrawlDoneListener {
    private static Log log = LogFactory.getLog(Crawler.class);
    List<Live> targetLives;
    ExtracterBase extracter;
    boolean crawling = false;
    OnCrawlStartListener crawlStartListener;
    OnCrawlDoneListener crawlDoneListener;
    boolean runningFlag = false;
    long nextInterval = 0L;
    long interval = 300000L;
    public static int WAIT_INTERVAL = 100;

    public Crawler(List<Live> targetLives, ExtracterBase extracter, OnCrawlStartListener crawlStartListener, OnCrawlDoneListener crawlDoneListener) {
        this.targetLives = targetLives;
        this.extracter = extracter;
        this.crawlStartListener = crawlStartListener;
        this.crawlDoneListener = crawlDoneListener;
    }

    @Override
    public void run() {
        while (true) {
            long now;
            try {
                Thread.sleep(WAIT_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((now = Calendar.getInstance().getTimeInMillis()) < this.nextInterval || !this.runningFlag) continue;
            this.nextInterval = now - now % this.interval + this.interval;
            log.info("[crawl schedule] now: " + now);
            log.info("[crawl schedule] next interval: " + this.nextInterval);
            if (this.crawlStartListener != null) {
                this.crawlStartListener.onCrawlStart(this.extracter);
                log.info("[crawl schedule] crawl starts: ");
            }
            log.info("[crawl schedule] crawl: ");
            this.extracter.crawl(this.targetLives, this);
        }
    }

    public void startCrawl() {
        if (!this.crawling) {
            this.nextInterval = 0L;
            this.runningFlag = true;
            this.crawling = true;
        } else {
            log.info("[crawl schedule] start crawl ignored for current crawling: ");
        }
    }

    public void stopCrawl() {
        this.runningFlag = false;
    }

    public boolean isRunning() {
        return this.runningFlag;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public ExtracterBase getExtracter() {
        return this.extracter;
    }

    @Override
    public void onCrawlDone(ExtracterBase extracter, List<Live> lives) {
        log.info("[crawl schedule] crawl done: ");
        this.crawling = false;
        if (this.crawlDoneListener != null) {
            this.crawlDoneListener.onCrawlDone(extracter, lives);
        }
    }

    public static interface OnCrawlStartListener {
        public void onCrawlStart(ExtracterBase var1);
    }
}

