#!/usr/bin/perl

use strict;
use Net::LDAP;
use Net::LDAP::Constant qw(:all);

sub searchLdap
{
    my ($self, $conf, $param, $pids, $base, $sizeLim, $filter) = @_;
    my @keys = ();
    my @entries = ();

    my $uri = URI->new($param->{uri}->{value});
    if (!$uri) {
        return (LDAP_OTHER, "Invalid uri", \@keys, @entries);
    }

    my $binddn = $param->{binddn}->{value};
    my $bindpw = $param->{bindpw}->{value};

    $self->{plugin}->{ldap} = Net::LDAP->new($param->{uri}->{value});
    my $msg = $self->{plugin}->{ldap}->bind($binddn, password => $bindpw);
    if ($msg->code) {
        return ($msg->code, $msg->error, \@keys, @entries);
    }

    my $searchdn = $uri->dn;
    $msg = $self->{plugin}->{ldap}->search(base => $searchdn, scope => $uri->scope, filter => $uri->filter);
    if (!$msg->code) {
        for (my $i = 0; $i < $msg->count; $i++) {
            my $entry = $msg->entry($i);
            my $dn = $entry->dn;
            $dn =~ s/$searchdn/$self->{suffix}/i;
            if ($dn !~ /$base$/i) {
                next;
            }

            my $entryStr = "dn: $dn\n";
            foreach my $attr ($entry->attributes) {
                foreach my $value ($entry->get_value($attr)) {
                    $value = decode('utf8', $value);
                    $entryStr = $entryStr.$attr.": $value\n";
                }
            }

           my $key = undef;
           if (defined($param->{id})) {
               if ($param->{id}->{type} eq 'regexp') {
                   ($key) = ($entryStr =~ /$param->{id}->{value}/i);
               } elsif ($param->{id}->{type} eq 'attribute') {
                   ($key) = ($entryStr =~ /^$param->{id}->{value}:\:? (.*)$/mi);
               }
            }

            push(@keys, $key);
            push(@entries, $entryStr);
        }
    }

    return ($msg->code, $msg->error, \@keys, @entries);
}
