/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel.modules.strategy;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import jp.maru.liquid.annotation.Plug;
import jp.maru.liquid.kernel.modules.strategy.HttpStrategy;
import jp.maru.liquid.plugin.HttpServerCommonPlugin;
import jp.maru.liquid.plugin.HttpTemplatePlugin;
import jp.maru.liquid.plugin.http.HttpRequest;
import jp.maru.liquid.plugin.http.HttpResponse;
import jp.maru.liquid.util.StringHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plug(value=HttpTemplatePlugin.class)
public class HttpTemplateStrategy
implements HttpStrategy {
    private static final Logger logger = LoggerFactory.getLogger(HttpTemplateStrategy.class);

    @Override
    public void execute(HttpServerCommonPlugin plugin, HttpRequest request, HttpResponse response) throws IOException {
        try {
            HttpTemplatePlugin pplugin = (HttpTemplatePlugin)((Object)plugin);
            StringHashMap<String, Object> modelMap = new StringHashMap<String, Object>();
            String templateName = pplugin.action(request, response, modelMap);
            if (templateName != null) {
                Configuration cfg = new Configuration();
                cfg.setDirectoryForTemplateLoading(new File(pplugin.getTemplatePath()));
                Template template = cfg.getTemplate(templateName);
                template.process(modelMap, (Writer)response.getWriter());
            } else {
                logger.warn("Template name is null. " + request.getRequestURI());
            }
        }
        catch (TemplateException te) {
            logger.error(te.toString(), (Throwable)te);
            te.printStackTrace();
        }
    }

    public String toString() {
        return "HttpTemplateStrategy";
    }
}

