/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel.modules.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import jp.maru.liquid.plugin.http.Cookie;
import jp.maru.liquid.plugin.http.HttpResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NByteArrayEntity;

public class HttpCoreResponse
implements HttpResponse {
    private org.apache.http.HttpResponse _response;
    private PrintWriter _writer;
    private ByteArrayOutputStream _byteOutStream;
    private String _contentType = "text/html";
    private String _encoding;
    private List<Cookie> _cookies;
    private String _redirectLocation;

    public HttpCoreResponse(org.apache.http.HttpResponse response) {
        this._response = response;
        this._byteOutStream = new ByteArrayOutputStream();
        this._cookies = new ArrayList<Cookie>();
    }

    @Override
    public void addCookie(Cookie cookie) {
        this._cookies.add(cookie);
    }

    @Override
    public void addHeader(String name, String value) {
        this._response.addHeader(name, value);
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this._writer == null) {
            OutputStreamWriter streamWriter = null;
            streamWriter = this._encoding != null ? new OutputStreamWriter((OutputStream)this._byteOutStream, this._encoding) : new OutputStreamWriter(this._byteOutStream);
            this._writer = new PrintWriter(streamWriter);
        }
        return this._writer;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this._byteOutStream;
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        for (Cookie cookie : this._cookies) {
            StringBuilder cookieLine = new StringBuilder();
            cookieLine.append(cookie.getName());
            cookieLine.append('=');
            cookieLine.append(cookie.getValue()).append(';');
            if (cookie.getMaxAge() != -1) {
                cookieLine.append(" expires=");
                if (cookie.getMaxAge() == 0) {
                    cookieLine.append("Thu, 01-Jan-1970 00:00:00 GMT;");
                } else {
                    SimpleDateFormat format = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss", Locale.US);
                    Date expireDate = new Date(System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L - 32400000L);
                    cookieLine.append(format.format(expireDate)).append(" GMT;");
                }
            }
            if (cookie.getPath() != null) {
                cookieLine.append(" path=").append(cookie.getPath()).append(';');
            }
            if (cookie.getDomain() != null) {
                cookieLine.append(" domain=").append(cookie.getDomain()).append(';');
            }
            this._response.addHeader((Header)new BasicHeader("Set-Cookie", cookieLine.toString()));
        }
        if (this._redirectLocation != null) {
            this._response.addHeader("Location", this._redirectLocation);
            this.setStatus(302);
        } else {
            NByteArrayEntity entity = new NByteArrayEntity(this._byteOutStream.toByteArray());
            entity.setContentType(this._contentType);
            this._response.setEntity((HttpEntity)entity);
        }
    }

    @Override
    public void sendRedirect(String location) {
        this._redirectLocation = location;
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.setStatus(sc);
        this.setContentType("text/html");
        this._byteOutStream = new ByteArrayOutputStream();
        this.flushBuffer();
    }

    @Override
    public void setStatus(int sc) {
        this._response.setStatusCode(sc);
    }

    @Override
    public void setContentType(String type) {
        this._contentType = type;
        int index = type.toLowerCase().indexOf("charset=");
        if (index != -1) {
            this._encoding = type.substring(index + 8);
        }
    }
}

