/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel.modules.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import jp.maru.liquid.kernel.modules.http.HttpGenericListener;
import jp.maru.liquid.plugin.http.Cookie;
import jp.maru.liquid.plugin.http.HttpSession;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCoreRequest
implements jp.maru.liquid.plugin.http.HttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpCoreRequest.class);
    private String _requestUri;
    private String _method;
    private String _query;
    private String _serverName;
    private Map<String, String> _parameterMap;
    private Cookie[] _cookies;
    private HttpGenericListener _eventListener;
    private HttpSession _session;
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private int _hashCode;
    private static Enumeration<String> NULL_ENUMERATION = new Enumeration<String>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            return null;
        }
    };

    public HttpCoreRequest(HttpRequest request) {
        try {
            String uri;
            int index;
            HttpEntity entity;
            Header contentType;
            this._method = request.getRequestLine().getMethod().toUpperCase();
            Header headerCookie = request.getFirstHeader("Cookie");
            if (headerCookie != null) {
                ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
                StringTokenizer tokenizer = new StringTokenizer(headerCookie.getValue(), ";,");
                while (tokenizer.hasMoreTokens()) {
                    String cookieLine = tokenizer.nextToken();
                    int delmIndex = cookieLine.indexOf(61);
                    String cookieName = cookieLine.substring(0, delmIndex).trim();
                    String cookieValue = cookieLine.substring(delmIndex + 1).trim();
                    cookieList.add(new Cookie(cookieName, cookieValue));
                    this._cookies = cookieList.toArray(new Cookie[0]);
                }
            }
            if (request instanceof HttpEntityEnclosingRequest && (contentType = (entity = ((HttpEntityEnclosingRequest)request).getEntity()).getContentType()).getValue().toLowerCase().trim().startsWith("application/x-www-form-urlencoded")) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                this.mapQuery(reader.readLine());
            }
            if ((index = (uri = request.getRequestLine().getUri()).indexOf(63)) != -1) {
                this._query = uri.substring(index + 1);
                this._requestUri = uri.substring(0, index);
                if (this._query.length() > 0) {
                    this.mapQuery(this._query);
                }
            } else {
                this._requestUri = uri;
            }
            this._serverName = request.getFirstHeader("Host") != null ? request.getFirstHeader("Host").getValue() : "";
        }
        catch (IOException ioe) {
            logger.warn(ioe.toString(), (Throwable)ioe);
            ioe.printStackTrace();
        }
        Random rand = new Random();
        this._hashCode = rand.nextInt();
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._parameterMap == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this._parameterMap.entrySet()) {
            entry.setValue(URLDecoder.decode(entry.getValue(), encoding));
        }
    }

    @Override
    public Cookie[] getCookies() {
        return this._cookies;
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    @Override
    public String getParameter(String name) {
        if (this._parameterMap == null) {
            return null;
        }
        return this._parameterMap.get(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (this._parameterMap == null) {
            return NULL_ENUMERATION;
        }
        final Iterator<String> iterator = this._parameterMap.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    @Override
    public String getQueryString() {
        return this._query;
    }

    @Override
    public String getRequestURI() {
        return this._requestUri;
    }

    @Override
    public String getServerName() {
        return this._serverName;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this._session == null) {
            this._eventListener.beforeGetSession(create);
        }
        return this._session;
    }

    private void mapQuery(String query) {
        if (query == null) {
            return;
        }
        if (this._parameterMap == null) {
            this._parameterMap = new HashMap<String, String>();
        }
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int delmIndex = token.indexOf(61);
            if (delmIndex == -1) continue;
            String name = token.substring(0, delmIndex);
            String value = token.substring(delmIndex + 1);
            this._parameterMap.put(name, value);
        }
    }

    public void setHttpGenericListener(HttpGenericListener listener) {
        this._eventListener = listener;
    }

    public void setSession(HttpSession session) {
        this._session = session;
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    @Override
    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public int hashCode() {
        return this._hashCode;
    }
}

