/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel.modules;

import java.io.IOException;
import jp.maru.liquid.annotation.Plug;
import jp.maru.liquid.kernel.modules.HttpServerModule;
import jp.maru.liquid.kernel.modules.http.AbstractNHttpRequestHandler;
import jp.maru.liquid.kernel.modules.http.DefaultHttpListener;
import jp.maru.liquid.kernel.modules.http.HttpCoreRequest;
import jp.maru.liquid.kernel.modules.http.HttpCoreResponse;
import jp.maru.liquid.plugin.AsyncHttpServerPlugin;
import jp.maru.liquid.plugin.Plugin;
import jp.maru.liquid.plugin.http.AsyncHttpEvent;
import jp.maru.liquid.plugin.http.AsyncTrigger;
import jp.maru.liquid.plugin.http.HttpResponse;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.protocol.NHttpResponseTrigger;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpServerModule
extends HttpServerModule {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpServerModule.class);

    @Override
    @Plug(value=AsyncHttpServerPlugin.class)
    public void plug(Plugin plugin) {
        AsyncHttpServerPlugin plugin0 = (AsyncHttpServerPlugin)plugin;
        this._connector.register(plugin0, new AsyncNHttpRequestHandlerImpl(plugin0));
    }

    @Override
    public String toString() {
        return "AsyncHttpServerPlugin";
    }

    static class AsyncListenerHttpEvent
    implements AsyncHttpEvent {
        private HttpCoreRequest _coreRequest;
        private HttpCoreResponse _coreResponse;

        AsyncListenerHttpEvent(NHttpConnection conn) {
            this._coreRequest = (HttpCoreRequest)conn.getContext().getAttribute("coreRequest");
            this._coreResponse = (HttpCoreResponse)conn.getContext().getAttribute("coreResponse");
        }

        @Override
        public jp.maru.liquid.plugin.http.HttpRequest getRequest() {
            return this._coreRequest;
        }

        @Override
        public HttpResponse getResponse() {
            return this._coreResponse;
        }

        public int hashCode() {
            return this._coreRequest.hashCode();
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            return this.hashCode() == o.hashCode();
        }

        public String toString() {
            return "AsyncEvent[" + this.hashCode() + "]";
        }
    }

    class AsyncNHttpRequestHandlerImpl
    extends AbstractNHttpRequestHandler {
        private AsyncHttpServerPlugin _plugin;

        AsyncNHttpRequestHandlerImpl(AsyncHttpServerPlugin plugin) {
            this._plugin = plugin;
            AsyncHttpServerModule.this._connector.addEventListener(new AsyncEventListener());
        }

        public void handle(HttpRequest request, final org.apache.http.HttpResponse response, final NHttpResponseTrigger trriger, HttpContext context) throws HttpException, IOException {
            AsyncHttpServerModule.this.callPreProcess();
            final HttpCoreRequest coreRequest = new HttpCoreRequest(request);
            final HttpCoreResponse coreResponse = new HttpCoreResponse(response);
            context.setAttribute("coreRequest", (Object)coreRequest);
            context.setAttribute("coreResponse", (Object)coreResponse);
            coreRequest.setHttpGenericListener(new DefaultHttpListener(coreRequest, coreResponse));
            this._plugin.httpConnected(new AsyncHttpEvent(){

                @Override
                public jp.maru.liquid.plugin.http.HttpRequest getRequest() {
                    return coreRequest;
                }

                @Override
                public HttpResponse getResponse() {
                    return coreResponse;
                }

                public int hashCode() {
                    return coreRequest.hashCode();
                }

                public boolean equals(Object o) {
                    if (super.equals(o)) {
                        return true;
                    }
                    return o instanceof AsyncHttpEvent && this.hashCode() == o.hashCode();
                }

                public String toString() {
                    return "AsyncEvent[" + this.hashCode() + "]";
                }
            }, new AsyncTrigger(){
                boolean _resumed;

                @Override
                public void resume() throws IOException {
                    if (this._resumed) {
                        return;
                    }
                    AsyncHttpServerModule.this._strategy.execute(AsyncNHttpRequestHandlerImpl.this._plugin, coreRequest, coreResponse);
                    coreResponse.flushBuffer();
                    AsyncHttpServerModule.this.callPostProcess();
                    trriger.submitResponse(response);
                    this._resumed = true;
                }
            });
        }

        class AsyncEventListener
        implements EventListener {
            AsyncEventListener() {
            }

            public void connectionOpen(NHttpConnection conn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Async connectionOpen -> " + conn);
                }
            }

            public void connectionTimeout(NHttpConnection conn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Async connectionTimeout -> " + conn);
                }
                if (conn.getContext().getAttribute("coreRequest") != null) {
                    AsyncNHttpRequestHandlerImpl.this._plugin.httpDisconnected(new AsyncListenerHttpEvent(conn));
                }
            }

            public void connectionClosed(NHttpConnection conn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Async connectionClosed -> " + conn);
                }
                if (conn.getContext().getAttribute("coreRequest") != null) {
                    AsyncNHttpRequestHandlerImpl.this._plugin.httpDisconnected(new AsyncListenerHttpEvent(conn));
                }
            }

            public void fatalIOException(IOException ex, NHttpConnection conn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Async fatalIOException -> " + conn);
                }
                if (conn.getContext().getAttribute("coreRequest") != null) {
                    AsyncNHttpRequestHandlerImpl.this._plugin.httpDisconnected(new AsyncListenerHttpEvent(conn));
                }
            }

            public void fatalProtocolException(HttpException ex, NHttpConnection conn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Async fatalProtocolException -> " + conn);
                }
                if (conn.getContext().getAttribute("coreRequest") != null) {
                    AsyncNHttpRequestHandlerImpl.this._plugin.httpDisconnected(new AsyncListenerHttpEvent(conn));
                }
            }
        }
    }
}

