/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.maru.liquid.annotation.DependentPlugin;
import jp.maru.liquid.kernel.PluginNotLoadedError;
import jp.maru.liquid.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(PluginManager.class);
    private List<Plugin> _plugins = new ArrayList<Plugin>();
    ExecutorService pluginExecutor = Executors.newCachedThreadPool();

    PluginManager() {
    }

    public void setPlugins(List<Plugin> plugins) {
        logger.info("Loading plugins...");
        for (Plugin plugin : plugins) {
            this._plugins.add(plugin);
            logger.info("+ " + plugin.getClass().getSimpleName());
        }
    }

    public void validatePluginDependence() {
        logger.info("Validate plugin dependence...");
        for (Plugin plugin : this._plugins) {
            Class<? extends Plugin>[] dependentPluginClasses;
            DependentPlugin dependentPlugin = plugin.getClass().getAnnotation(DependentPlugin.class);
            if (dependentPlugin == null) {
                logger.info("  " + plugin.getClass().getSimpleName() + " dependence: PASS");
                continue;
            }
            for (Class<? extends Plugin> dependentPluginClass : dependentPluginClasses = dependentPlugin.value()) {
                if (this.hasPlugin(dependentPluginClass)) continue;
                logger.error("  " + plugin.getClass().getSimpleName() + " dependence: ERROR");
                throw new PluginNotLoadedError(plugin.getClass().getSimpleName() + " depend on " + dependentPluginClass.getSimpleName());
            }
            logger.info("  " + plugin.getClass().getSimpleName() + " dependence: OK");
        }
    }

    public void initPlugins() {
        for (Plugin plugin : this._plugins) {
            logger.info("Initialize " + plugin.getClass().getSimpleName());
            plugin.init();
        }
    }

    public boolean hasPlugin(Class<? extends Plugin> pluginClass) {
        for (Plugin plugin : this._plugins) {
            if (!pluginClass.isAssignableFrom(plugin.getClass())) continue;
            return true;
        }
        return false;
    }

    public List<? extends Plugin> getPlugins() {
        List list = (List)((ArrayList)this._plugins).clone();
        return list;
    }
}

