/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.kernel;

import java.util.List;
import jp.maru.liquid.kernel.ModuleManager;
import jp.maru.liquid.kernel.PluginManager;
import jp.maru.liquid.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Kernel {
    public static final String VERSION = "0.5.2";
    private static final Logger logger = LoggerFactory.getLogger(Kernel.class);
    private static Kernel __kernel;
    private Thread _bootThread;
    private ModuleManager _moduleManager;
    private PluginManager _pluginManager;

    public static void startup() {
        if (__kernel != null) {
            throw new IllegalStateException("Already Kernel startup.");
        }
        __kernel = new Kernel();
    }

    public static Kernel getInstance() {
        if (__kernel == null) {
            throw new NullPointerException("Kernel is not running.");
        }
        return __kernel;
    }

    private Kernel() {
        logger.info("Liquid Framewok 0.5.2");
        this.loadModules();
        this.loadPlugins();
        this._bootThread = new Thread(new Runnable(){

            @Override
            public synchronized void run() {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    logger.error("Interrupted " + ie);
                }
            }
        });
        this._bootThread.start();
    }

    private void loadModules() {
        try {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("module.xml");
            this._moduleManager = (ModuleManager)context.getBean("moduleManager");
            this._moduleManager.initModules();
        }
        catch (Exception e) {
            logger.error("Module initialize error.", (Throwable)e);
            throw new RuntimeException("Module initialize error.", e);
        }
    }

    private void loadPlugins() {
        try {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("plugin.xml");
            this._pluginManager = (PluginManager)context.getBean("pluginManager");
            this._pluginManager.validatePluginDependence();
            this._pluginManager.initPlugins();
            this._moduleManager.plugPlugins(this._pluginManager);
        }
        catch (Exception e) {
            logger.error("Plugin initialize error.", (Throwable)e);
            throw new RuntimeException("Plugin initialize error.", e);
        }
    }

    public List<? extends Plugin> getPlugins() {
        return this._pluginManager.getPlugins();
    }
}

