/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins.http.util;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import jp.maru.liquid.core.plugins.http.ActionContext;
import jp.maru.liquid.core.plugins.http.ActionError;
import jp.maru.liquid.plugin.http.HttpRequest;
import jp.maru.liquid.util.StringHashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionHelper {
    private static final Logger logger = LoggerFactory.getLogger(ActionHelper.class);

    public static Map<String, Object> getParameters(HttpRequest request) {
        Enumeration<String> enu = request.getParameterNames();
        StringHashMap<String, Object> map = new StringHashMap<String, Object>();
        while (enu.hasMoreElements()) {
            String paramName = enu.nextElement();
            map.put(paramName, request.getParameter(paramName));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Param -> " + paramName + "=" + request.getParameter(paramName));
        }
        return map;
    }

    public static String convertErrorToJSON(ActionContext context) {
        JSONObject json = new JSONObject();
        json.put((Object)"result", (Object)Boolean.FALSE);
        JSONArray jarray = new JSONArray();
        json.put((Object)"errors", (Object)jarray);
        List<ActionError> errors = context.getActionErrors();
        for (ActionError error : errors) {
            JSONObject jobj = new JSONObject();
            jobj.put((Object)"property", (Object)error.getPropertyName());
            jobj.put((Object)"message", (Object)error.getMessage());
            jarray.add((Object)jobj);
        }
        return json.toString();
    }
}

