/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins.http;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import jp.maru.liquid.core.plugins.http.ActionContext;
import jp.maru.liquid.core.plugins.http.ActionInvocation;
import jp.maru.liquid.core.plugins.http.ActionProxy;
import jp.maru.liquid.core.plugins.http.ActionProxyFactory;
import jp.maru.liquid.core.plugins.http.HttpFileNotFoundException;
import jp.maru.liquid.core.plugins.http.HttpServerException;
import jp.maru.liquid.core.plugins.http.annotation.DiscardOnComplete;
import jp.maru.liquid.core.plugins.http.annotation.ErrorsTo;
import jp.maru.liquid.core.plugins.http.annotation.Intercept;
import jp.maru.liquid.core.plugins.http.annotation.TransferOnComplete;
import jp.maru.liquid.core.plugins.http.interceptor.Interceptor;
import jp.maru.liquid.plugin.http.HttpRequest;
import jp.maru.liquid.plugin.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionProxyFactory
implements ActionProxyFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultActionProxyFactory.class);

    @Override
    public ActionProxy createActionProxy(HttpRequest request, ActionContext actionContext, Class<? extends Object> action, final String methodName) throws HttpServerException {
        final ActionInvocationImpl actionInvocation = new ActionInvocationImpl(request, actionContext, action, methodName);
        ActionProxy actionProxy = new ActionProxy(){

            @Override
            public String execute() {
                return actionInvocation.invoke();
            }

            @Override
            public Object getAction() {
                return actionInvocation.getAction();
            }

            @Override
            public String getMethod() {
                return methodName;
            }

            @Override
            public ActionInvocation getInvocation() {
                return actionInvocation;
            }
        };
        actionInvocation._actionProxy = actionProxy;
        return actionProxy;
    }

    private static class ActionInvocationWrapper
    implements ActionInvocation {
        private ActionInvocation _parentInvocation;
        private Interceptor _interceptor;

        public ActionInvocationWrapper(ActionInvocation actionInvocation, Interceptor interceptor) {
            this._parentInvocation = actionInvocation;
            this._interceptor = interceptor;
        }

        @Override
        public String invoke() {
            return this._parentInvocation.invoke();
        }

        @Override
        public String invokeActionOnly() {
            return this._parentInvocation.invokeActionOnly();
        }

        @Override
        public Object getAction() {
            return this._interceptor;
        }

        @Override
        public ActionContext getInvocationContext() {
            return this._parentInvocation.getInvocationContext();
        }

        @Override
        public ActionProxy getProxy() {
            return this._parentInvocation.getProxy();
        }

        public String toString() {
            return "ActionInvocationWrapper[" + this._interceptor + "]";
        }
    }

    private static class IntercepteProxy {
        Interceptor _interceptor;
        ActionInvocation _actionInvocation;

        public IntercepteProxy(Interceptor interceptor, ActionInvocation actionInvocation) {
            this._interceptor = interceptor;
            this._actionInvocation = actionInvocation;
        }

        public String intercept() {
            if (logger.isDebugEnabled()) {
                logger.debug("INTERCEPT " + this._interceptor + " -> " + this._actionInvocation);
            }
            return this._interceptor.intercept(this._actionInvocation);
        }
    }

    public static class ActionInvocationImpl
    implements ActionInvocation {
        private int _invokeIndex;
        private HttpRequest _request;
        private Class<? extends Object> _action;
        private String _methodName;
        private String _errorsTo;
        private Object _actionObject;
        private Method _method;
        private IntercepteProxy[] _intercepteProxies;
        private ActionProxy _actionProxy;
        private ActionContext _actionContext;

        private ActionInvocationImpl(HttpRequest request, ActionContext actionContext, Class<? extends Object> action, String methodName) throws HttpServerException {
            try {
                HttpSession session;
                Object transAction;
                this._request = request;
                this._actionContext = actionContext;
                this._action = action;
                this._method = action.getMethod(methodName, new Class[0]);
                Intercept intercept = action.getAnnotation(Intercept.class);
                ErrorsTo errorsTo = action.getAnnotation(ErrorsTo.class);
                if (errorsTo != null) {
                    this._errorsTo = errorsTo.value();
                }
                this._actionObject = (transAction = (session = request.getSession()).getAttribute(action.toString())) != null ? transAction : action.newInstance();
                this._actionContext.setAction(this._actionObject);
                if (intercept != null) {
                    Class<? extends Interceptor>[] interceptors = intercept.value();
                    ArrayList<IntercepteProxy> loadList = new ArrayList<IntercepteProxy>();
                    this.seekInterceptors(this, interceptors, loadList);
                    this._intercepteProxies = loadList.toArray(new IntercepteProxy[0]);
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new HttpFileNotFoundException("Method is not found. " + action.getName() + "/" + methodName);
            }
            catch (InstantiationException ie) {
                logger.error(ie.toString(), (Throwable)ie);
                ie.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                logger.error(iae.toString(), (Throwable)iae);
                iae.printStackTrace();
            }
        }

        private void seekInterceptors(ActionInvocation invocation, Class<? extends Interceptor>[] interceptors, List<IntercepteProxy> loadList) throws InstantiationException, IllegalAccessException {
            for (Class<? extends Interceptor> interceptorClass : interceptors) {
                Interceptor interceptor = interceptorClass.newInstance();
                Intercept intercept = interceptorClass.getAnnotation(Intercept.class);
                if (intercept != null) {
                    ActionInvocationWrapper imitation = new ActionInvocationWrapper(this, interceptor);
                    this.seekInterceptors(imitation, intercept.value(), loadList);
                }
                loadList.add(new IntercepteProxy(interceptor, invocation));
            }
        }

        @Override
        public String invoke() {
            if (this._intercepteProxies == null || this._intercepteProxies.length < this._invokeIndex + 1) {
                return this.invokeActionOnly();
            }
            return this._intercepteProxies[this._invokeIndex++].intercept();
        }

        @Override
        public String invokeActionOnly() {
            try {
                DiscardOnComplete discardOnComp;
                Method[] methods = this._action.getMethods();
                HashMap<String, Method> methodMap = new HashMap<String, Method>();
                for (Method method : methods) {
                    methodMap.put(method.getName(), method);
                }
                Enumeration<String> params = this._request.getParameterNames();
                while (params.hasMoreElements()) {
                    String paramName = params.nextElement();
                    Object paramValue = this._request.getParameter(paramName);
                    StringBuilder paramMethodName = new StringBuilder("set").append(Character.toUpperCase(paramName.charAt(0))).append(paramName.substring(1));
                    try {
                        Method paramMethod = (Method)methodMap.get(paramMethodName.toString());
                        if (paramMethod == null) {
                            logger.warn("Can't set parameter '" + paramName + "', Method is not found.");
                            continue;
                        }
                        Class<?>[] paramTypes = paramMethod.getParameterTypes();
                        if (paramTypes.length != 1) {
                            logger.warn("Can't set parameter '" + paramName + "', Method parameters mismatch.");
                            continue;
                        }
                        if (paramTypes[0].equals(Integer.TYPE) || paramTypes[0].equals(Integer.class)) {
                            paramValue = new Integer(((String)paramValue).replace(" ", "").replace(",", ""));
                        } else if (paramTypes[0].equals(Boolean.TYPE) || paramTypes[0].equals(Boolean.class)) {
                            String booleanParam = ((String)paramValue).toLowerCase().trim();
                            paramValue = booleanParam.equals("yes") || booleanParam.equals("on") || booleanParam.equals("true") ? Boolean.TRUE : new Boolean(booleanParam);
                        }
                        paramMethod.invoke(this._actionObject, paramValue);
                    }
                    catch (NumberFormatException nfe) {
                        logger.warn("Can't set parameter '" + paramName + "'. " + nfe);
                    }
                    catch (IllegalAccessException iae) {
                        logger.warn("Can't set parameter '" + paramName + "'. " + iae);
                    }
                }
                Object templateName = this._method.invoke(this._actionObject, new Object[0]);
                if (templateName == null) {
                    return this._methodName + ".ftl";
                }
                TransferOnComplete transOnComp = this._method.getAnnotation(TransferOnComplete.class);
                if (transOnComp != null) {
                    HttpSession session = this._request.getSession();
                    session.setAttribute(this._action.toString(), this._actionObject);
                }
                if ((discardOnComp = this._method.getAnnotation(DiscardOnComplete.class)) != null) {
                    HttpSession session = this._request.getSession();
                    session.removeAttribute(this._action.toString());
                }
                return (String)templateName;
            }
            catch (IllegalAccessException iae) {
                logger.error(iae.toString(), (Throwable)iae);
                iae.printStackTrace();
                return this._errorsTo;
            }
            catch (InvocationTargetException ite) {
                logger.error(ite.toString(), (Throwable)ite);
                ite.printStackTrace();
                return this._errorsTo;
            }
        }

        @Override
        public Object getAction() {
            return this._actionObject;
        }

        @Override
        public ActionContext getInvocationContext() {
            return this._actionContext;
        }

        @Override
        public ActionProxy getProxy() {
            return this._actionProxy;
        }

        public String toString() {
            return "ActionInvocation[" + this._action + "]";
        }
    }
}

