/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.plugins;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import jp.maru.liquid.core.plugins.http.ActionEngine;
import jp.maru.liquid.core.plugins.http.HttpFileNotFoundException;
import jp.maru.liquid.core.plugins.http.HttpServerException;
import jp.maru.liquid.plugin.HttpBasicPlugin;
import jp.maru.liquid.plugin.HttpServerPlugin;
import jp.maru.liquid.plugin.http.HttpRequest;
import jp.maru.liquid.plugin.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOutputActionPlugin
implements HttpServerPlugin,
HttpBasicPlugin {
    private static final Logger logger = LoggerFactory.getLogger(HttpOutputActionPlugin.class);
    private String _bindUri;
    private String _encoding;
    private String _actionClass;

    @Override
    public void init() {
    }

    @Override
    public void execute(HttpRequest request, HttpResponse response) {
        block5: {
            try {
                ActionEngine engine = new ActionEngine(this._actionClass, request, response);
                engine.setContentType("text/html");
                engine.setCharacterEncoding(this._encoding);
                response.getWriter().print(engine.execute());
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn("Action is not found. " + request.getRequestURI());
            }
            catch (UnsupportedEncodingException se) {
                logger.error("Encoding is unsupported. " + this._encoding);
            }
            catch (IOException ioe) {
                logger.warn(ioe.getMessage(), (Throwable)ioe);
            }
            catch (HttpServerException hse) {
                logger.warn(hse.getMessage());
                if (!(hse instanceof HttpFileNotFoundException)) break block5;
                HttpOutputActionPlugin.sendError(response, 404);
            }
        }
    }

    @Override
    public void setBindURI(String uri) {
        this._bindUri = uri;
    }

    @Override
    public String getBindURI() {
        return this._bindUri;
    }

    public void setActionClass(String actionClass) {
        this._actionClass = actionClass;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    private static void sendError(HttpResponse response, int sc) {
        try {
            response.sendError(404);
        }
        catch (IOException ioe) {
            logger.warn(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public String toString() {
        return "HttpOutputActionPlugin";
    }
}

