/*
 * Decompiled with CFR 0.152.
 */
package jp.maru.liquid.core.hibernate;

import java.util.HashMap;
import java.util.Map;
import jp.maru.liquid.core.hibernate.HibernateQuery;
import jp.maru.liquid.core.hibernate.HibernateTransaction;
import jp.maru.liquid.plugin.session.Query;
import jp.maru.liquid.plugin.session.Session;
import jp.maru.liquid.plugin.session.Transaction;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateSession
implements Session {
    public static Logger logger = LoggerFactory.getLogger(HibernateSession.class);
    private static final Map<Thread, Session> __sessionPool = new HashMap<Thread, Session>();
    private SessionFactory _sessionFactory;
    private org.hibernate.Session _session;
    private Transaction _transaction;

    public HibernateSession(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    @Override
    public void open() {
        HibernateSession session = (HibernateSession)__sessionPool.get(Thread.currentThread());
        this._session = session == null ? this._sessionFactory.openSession() : session._session;
        __sessionPool.put(Thread.currentThread(), this);
        if (logger.isDebugEnabled()) {
            if (session == null) {
                logger.debug("Session is attached. -> " + Thread.currentThread());
            } else if (logger.isDebugEnabled()) {
                logger.debug("Session is re-used. -> " + Thread.currentThread());
            }
        }
    }

    @Override
    public <T> T execute(Query<T> query) {
        HibernateQuery hquery = (HibernateQuery)query;
        return hquery.execute(this._session);
    }

    @Override
    public void close() {
        this._session.close();
        __sessionPool.remove(Thread.currentThread());
        if (logger.isDebugEnabled()) {
            logger.debug("Session is released. -> " + Thread.currentThread());
        }
    }

    @Override
    public Transaction beginTransaction() {
        this._transaction = this.getTransaction();
        this._transaction.begin();
        return this._transaction;
    }

    @Override
    public Transaction getTransaction() {
        if (this._transaction == null) {
            this._transaction = new HibernateTransaction(this._session.getTransaction());
        }
        return this._transaction;
    }

    public static void releaseCurrentSession() {
        Session session = __sessionPool.get(Thread.currentThread());
        if (session != null) {
            session.close();
        }
    }

    @Override
    public void refresh(Object object) {
        this._session.refresh(object);
    }
}

