############################################################
# Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
############################################################

require 'wiiremote'

WRMT::init()

num = WRMT::num_wiiremote
if num == 0 then
	puts "No WiiRemote found."
	exit
end

WRMT::wiiremotes.each(){ |wiiremote|
	wiiremote.open()
	wiiremote.ir = true;
}

done = false
until done do
	while (updated_index = WRMT::poll()) >= 0 do
		wiiremote = WRMT::wiiremotes[updated_index]
		printf("[%d] : p1(%s, %d, %d, %d) p2(%s, %d, %d, %d)\n",
			updated_index,
			wiiremote[WRMT::DATA_IR1_FOUND] == 1,
			wiiremote[WRMT::DATA_IR1_SIZE],
			wiiremote[WRMT::DATA_IR1_X],
			wiiremote[WRMT::DATA_IR1_Y],
			wiiremote[WRMT::DATA_IR2_FOUND] == 1,
			wiiremote[WRMT::DATA_IR2_SIZE],
			wiiremote[WRMT::DATA_IR2_X],
			wiiremote[WRMT::DATA_IR2_Y])
		done = true if wiiremote.check_button_all("AB")
	end
	sleep(0.03);
end

WRMT::quit()
